var View = require('./View');
var inherit = require('inherit');

/**
 * Creates a view capable of appending nested views and compiling them recursively
 *
 * @typedef {View} CompositeView
 * @extends View
 */
module.exports = inherit(View, {
    /**
     * @constructs CompositeView
     * @extends View
     */
    __constructor: function() {
        this._nestedViews = [];
    },

    append: function(nestedView) {
        require('assert')(nestedView instanceof View, 'Appended subview should be an instance of View');
        this._nestedViews.push(nestedView);
        return this;
    },

    getNestedViews: function() {
        return this._nestedViews;
    },

    compile: function() {
        var _ = require('lodash');

        var compiledViews = _.map(this.getNestedViews(), function(nestedView) {
            return nestedView.compile();
        });

        return _.merge.apply(null, [{}].concat(compiledViews)); //Merge an array of compiled views into a single object
    }
});
