var inherit = require('inherit');
var Interface = require('../Interface');

/**
 * A common interface for views
 *
 * Use as is as a standalone view or a leaf view in a composite structure
 *
 * @typedef {View}
 * @constructs {View}
 */
module.exports = inherit(
    {
        /**
         * Abstract function to compiling a view for templating
         * @throws
         */
        compile: function() {
            throw new Error('Abstract. To be implemented');
        },

        /**
         * Append a view to a collection of nested views
         * @returns {View}
         */
        append: function() {
            /**
             * @name View
             */
            return this;
        },

        /**
         * Returns an array of nested views
         * @returns {View[]}
         */
        getNestedViews: function() {
            return [];
        }
    },
    {
        $interface: new Interface(
            // Create an object to be passed to yate for templating
            'compile:0',

            // Append a subview to this view
            'append:1',

            // Get an array of direct sub views
            'getNestedViews:0'
        )
    }
);
