var util = require('util');

function getUrls(opts) {
    var lang = opts.lang || 'ru';
    var domain = opts.domain || 'domain';
    var host = opts.host || util.format('passport.yandex.%s', domain);
    var itunesLang = lang === 'uk' ? 'ua' : lang;

    return {
        applUrl: util.format(
            'https://itunes.apple.com/%s/app/andeks.kluc-dla-zasity-akkaunta/id957324816?l=%s',
            itunesLang,
            itunesLang
        ),
        googUrl: util.format('https://play.google.com/store/apps/details?id=ru.yandex.key&hl=%s', lang),
        promoUrl: util.format('https://yandex.%s/promo/2fa', domain),
        enable2faUrl: util.format('https://%s/profile/access/2fa', host),
        profileAccessUrl: util.format('https://%s/profile/access', host)
    };
}

exports.getUrls = getUrls;
