/* eslint-env node */

/**
 * @class Page
 * @typedef Page
 */
module.exports = require('inherit')({
    name: null,

    /**
     * @param {Controller} controller
     * @param {Api} api
     * @constructor Page
     * @class Page
     */
    __constructor: function(controller, api, lang) {
        require('assert')(controller instanceof require('../lib/controller'), 'Controller instance expected');
        require('assert')(api instanceof require('../lib/api/passport'), 'Api instance expected');
        require('assert')(this.name && typeof this.name === 'string', 'Page name should be defined for logging');
        require('assert')(typeof lang === 'string' && lang.length === 2, 'Lang should be a 2-letter lang code');

        this._controller = controller;
        this._api = api;
        this._lang = lang;

        this._logger = new (require('plog'))(this._controller.getLogId(), 'passport', 'page', this.name);
    },

    /**
     * This method is called when the page receives control.
     * From now on the system outside does not controls the flow, the page does.
     */
    open: function() {
        throw new Error('Should be overwritten');
    }
});
