// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
var headerMetrics = ['Челленджи в домике v1'];

function sendMetric(params) {
    if (headerMetrics) {
        passport.Metrika.count(headerMetrics.concat(params));
    }
}

$(function() {
    // инициализация блоков паспорта
    // валидации, индикации и т.п.

    $('input:visible')
        .first()
        .focus();

    passport.block('challenges', {
        events: {
            'click .js-toggle-challenge': 'toggleChallenge',
            'click .js-challenge-submit': 'checkForm',
            'click .js-challenge-restore': 'sendMetrics'
        },

        formEl: null,

        sendMetrics: function(event) {
            if (event.target.tagName === 'A') {
                sendMetric(['Челендж с ' + $(event.currentTarget).data('challenge') + ', не могу восстановить']);
            }
        },

        toggleChallenge: function(event) {
            var challengeBlock = '.challenge-' + $(event.currentTarget).data('challenge');

            event.preventDefault();
            $('.auth-challenge').addClass('g-hidden');
            $('.p-control__error').addClass('g-hidden');
            this.controlWrapper.removeClass('p-control-wrapper-error');
            $(challengeBlock).removeClass('g-hidden');
        },

        checkForm: function(event) {
            this.formEl = $(event.currentTarget).parents('form');

            var input = this.formEl.find('input[name="answer"]');
            var inputType = input.data('field');
            var val = input.val();

            if (typeof val === 'undefined') {
                this.formEl.submit();
                return;
            }

            event.preventDefault();

            if ($.trim(val) === '') {
                this.showInputErrors();
            } else {
                if (inputType === 'phone') {
                    this.validatePhoneNumber(val);
                }

                if (inputType === 'code') {
                    this.validateCode(val);
                }

                if (inputType === 'email') {
                    this.validateEmail(val);
                }

                if (inputType === 'question') {
                    this.hideInputErrors();
                    this.formEl.submit();
                }
            }
        },

        validateEmail: function(val) {
            if (!/[^ @]*@[^ @]*/.test(val)) {
                this.showInputErrors();
            } else {
                this.hideInputErrors();
                this.formEl.submit();
            }
        },

        validateCode: function(val) {
            if (!/\d{6}/.test(val)) {
                this.showInputErrors();
            } else {
                this.hideInputErrors();
                this.formEl.submit();
            }
        },

        validatePhoneNumber: function(val) {
            var that = this;

            passport.api
                .request(
                    'phone',
                    {phone_number: val},
                    {
                        cache: false,
                        abortPrevious: true
                    }
                )
                .done(function(response) {
                    if (response.validation_errors && !response.phone_number) {
                        that.showInputErrors();
                    } else {
                        that.hideInputErrors();
                        that.formEl.submit();
                    }
                })
                .fail(function() {
                    location.href = location.protocol + '//' + location.host + '/auth';
                });
        },

        showInputErrors: function() {
            $('.p-control__error').addClass('g-hidden');
            this.missingValueMessage.removeClass('g-hidden');
            this.controlWrapper.addClass('p-control-wrapper-error');
        },

        hideInputErrors: function() {
            $('.p-control__error').addClass('g-hidden');
            this.controlWrapper.removeClass('p-control-wrapper-error');
        },

        init: function() {
            var challengeType = $('#challenge-type').val();

            this.missingValueMessage = $('.p-control__error__challenge-errors_missingvalue');
            this.controlWrapper = $('.p-control-wrapper');

            sendMetric(['Показ страницы подтверждения входа с ' + challengeType]);
        }
    });

    passport.init();
});
