// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/auth.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/domik/domik.js */

$(function() {
    var headerMetrics = ['Страница авторизации'];
    var metricEvent = 'mousedown';
    var submit = passport.block('submit');
    var isTouch = $('html').hasClass('is-touch') || $('html').hasClass('is-tablet');
    var origin = passport.util.getUrlParam('origin') || 'passport_auth2reg';
    var flags = $('body').data('flags');

    headerMetrics.push(origin);

    submit.onValid = function() {
        this.onSubmit();
        this.$el.closest('form').submit();
        this.$('button[type=submit]').attr('disabled', true);

        sendMetric(['Отправка формы авторизации']);

        goal('sendAuthForm');

        passport.block('domik').lastAction = null;
    };

    submit.onInvalid = function() {
        var keys = Object.keys(passport.validator.store);
        var control;
        var i;

        for (i = 0; i < keys.length; i++) {
            if (!passport.validator.store[keys[i]]) {
                control = keys[i];
                break;
            }
        }

        if (control) {
            passport.block(control).validate();
        }
    };

    if ('ontouchstart' in window) {
        metricEvent = 'touchstart';
    }

    function sendMetric(params) {
        if (headerMetrics) {
            passport.Metrika.count(headerMetrics.concat(params));
        }
    }

    function goal(id) {
        var target = id;

        if (flags) {
            target = flags.replace('=', '_') + '_' + id;
        }

        passport.Metrika.reachGoal(target);
    }

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();

    if (!isTouch) {
        $('input:visible')
            .first()
            .focus();
    }

    $(document).on(metricEvent, '.js-submit-button', function() {
        sendMetric(['Клик на кнопку Войти']);
    });

    $(document).on(metricEvent, '.pseudo-button_register', function() {
        sendMetric(['Клик на кнопку Регистрация']);
    });

    $(document).on(metricEvent, '.pseudo-button_remember', function() {
        sendMetric(['Клик на кнопку Вспомнить пароль']);

        goal('pushRestoreButton');
    });

    $(document).on(metricEvent, '.js-scl-button', function(e) {
        sendMetric(['Начало соц.авторизации', {provider: $(e.target).data('provider')}]);

        goal('startSocialAuth_' + $(e.target).data('provider'));
    });

    $(document).on('errorShown.login-auth', function(e, code) {
        sendMetric(['Логин', {'Показ ошибки': code}]);
    });

    $(document).on('errorShown.password-auth', function(e, code) {
        sendMetric(['Пароль', {'Показ ошибки': code}]);
    });

    $(document).on('errorShown.domik', function(e, msg) {
        sendMetric([{'Общая ошибка': msg}]);
    });

    sendMetric(['Показ страницы']);
    goal('showDomik');

    if ($('.js-accounts').length) {
        goal('showDomikMultiAuth');
    } else {
        goal('showDomikEmpty');
    }

    if ($('.js-error-isle').length) {
        sendMetric([{'Общая ошибка': $('.error-msg').text()}]);
    }
});
