/**
 * @jsx React.DOM
 */
// The above declaration must remain intact at the top of the script.
// Your code here

var UserBox = React.createClass({
    displayName: 'UserBox',
    loadUsersFromServer: function() {
        $.ajax({
            url: this.props.url,
            dataType: 'json',
            success: function(data) {
                this.setState({
                    users: data.users,
                    default_uid: data.default_uid,
                    yu: (function() {
                        var cookiesArr = document.cookie.split(';');
                        var _cookies = {};
                        cookiesArr.forEach(function(item) {
                            var split = item.split('=');
                            _cookies[split.shift().trim()] = split.join('=');
                        });

                        return _cookies['yandexuid'] || '';
                    })()
                });
            }.bind(this),
            error: function(xhr, status, err) {
                console.error(this.props.url, status, err.toString());
            }.bind(this)
        });
    },
    getInitialState: function() {
        return {users: [], default_uid: null, idkey: null, captcha_url: null};
    },
    handleRefresh: function(data) {
        var self = this;
        var msg = /.*status=([^&]*)(&.*)?/.exec(data.msg_text);
        var url = /.*url=([^&]*)(&.*)?/.exec(data.msg_text);
        var idkey = /.*idkey=([^&]*)(&.*)?/.exec(data.msg_text);
        var captcha_url = /.*captcha_url=([^&]*)(&.*)?/.exec(data.msg_text);
        msg = msg && msg[1];

        $("input[name='password'], input[name='captcha_answer']").val('');

        if (idkey) {
            self.setState({idkey: idkey[1]});
        } else {
            self.setState({idkey: null});
        }
        if (captcha_url) {
            self.setState({captcha_url: decodeURIComponent(captcha_url[1])});
        } else {
            self.setState({captcha_url: null});
        }
        if (msg === 'ok') {
            self.setState({msg_text: ''});
        } else {
            self.setState({msg_text: msg});
        }
        if (msg === 'other') {
            url = url && url[1];
            top.location = decodeURIComponent(url);
        }
        self.loadUsersFromServer();
    },
    componentWillMount: function() {
        var self = this;
        window.response = function(url) {
            self.handleRefresh({msg_text: url});
        };
        window.addEventListener(
            'message',
            function receiveMessage(event) {
                self.handleRefresh({msg_text: JSON.parse(event.data)['async-auth']});
            },
            false
        );
        //setInterval(this.loadUsersFromServer, this.props.pollInterval);
        self.loadUsersFromServer();
    },
    render: function() {
        return React.DOM.div(
            {className: 'userBox'},
            React.DOM.h2(null, 'Добавить:'),
            React.DOM.form(
                {className: 'loginForm', action: '/passport?mode=embeddedauth', method: 'POST', target: 'authiframe'},
                React.DOM.table(
                    null,
                    React.DOM.tr(
                        null,
                        React.DOM.td(
                            null,
                            React.DOM.input({
                                type: 'hidden',
                                name: 'retpath',
                                value: 'https://' + window.location.host + '/auth/login-status.html'
                            }),
                            React.DOM.input({type: 'hidden', name: 'idkey', value: this.state.idkey}),
                            React.DOM.input({type: 'hidden', name: 'twoweeks', value: '1'}),
                            React.DOM.input({type: 'text', name: 'login', placeholder: 'Логин:'})
                        ),
                        React.DOM.td(
                            null,
                            React.DOM.input({type: 'password', name: 'password', placeholder: 'Пароль:'})
                        ),
                        React.DOM.td(null, React.DOM.button(null, 'Добавить'))
                    ),
                    React.DOM.tr(
                        null,
                        React.DOM.td(
                            {colSpan: '3'},
                            React.DOM.label(
                                null,
                                React.DOM.input({type: 'checkbox', name: 'twoweeks', value: '0'}),
                                ' Чужой компьютер'
                            )
                        )
                    )
                ),
                Captcha({url: this.state.captcha_url})
            ),
            React.DOM.h2(null, 'Пользователи в куке:'),
            UserList({
                onRefresh: this.handleRefresh,
                users: this.state.users,
                default_uid: this.state.default_uid,
                yu: this.state.yu
            }),
            Message({msg_text: this.state.msg_text})
        );
    }
});

var UserList = React.createClass({
    displayName: 'UserList',
    render: function() {
        var default_uid = this.props.default_uid;
        var yu = this.props.yu;
        var userNodes =
            this.props.users &&
            this.props.users.map(function(user) {
                return User({
                    key: user.uid && user.uid.value,
                    login: user.login,
                    display_name: user.display_name && user.display_name.name,
                    uid: user.uid && user.uid.value,
                    is_default: user.uid && user.uid.value === default_uid ? '1' : '0',
                    secure: String(user.auth && user.auth.secure),
                    password_age: user.auth && user.auth.password_verification_age,
                    social_profile_id: user.auth && user.auth.social && user.auth.social.profile_id,
                    status: user.status && user.status.value,
                    yu: yu
                });
            });
        return React.DOM.div(
            {className: 'userList'},
            React.DOM.table(
                {className: 'user'},
                React.DOM.thead(
                    null,
                    React.DOM.tr(
                        null,
                        React.DOM.th(null, 'login'),
                        React.DOM.th(null, 'uid'),
                        React.DOM.th(null, 'display name'),
                        React.DOM.th(null, 'secure'),
                        React.DOM.th(null, 'password age'),
                        React.DOM.th(null, 'social profile id'),
                        React.DOM.th(null, 'status'),
                        React.DOM.th(null),
                        React.DOM.th(null)
                    )
                ),
                userNodes
            )
        );
    }
});

var User = React.createClass({
    displayName: 'User',
    render: function() {
        return React.DOM.tr(
            {className: this.props.is_default === '1' ? 'default' : ''},
            React.DOM.td(null, this.props.login),
            React.DOM.td(null, this.props.uid),
            React.DOM.td(null, this.props.display_name),
            React.DOM.td(null, this.props.secure),
            React.DOM.td(null, this.props.password_age),
            React.DOM.td(null, this.props.social_profile_id),
            React.DOM.td(null, this.props.status),
            React.DOM.td(
                null,
                React.DOM.form(
                    {action: '/passport?mode=embeddedauth', method: 'POST', target: 'authiframe'},
                    React.DOM.input({type: 'hidden', name: 'action', value: 'change_default'}),
                    React.DOM.input({type: 'hidden', name: 'uid', value: this.props.uid}),
                    React.DOM.input({type: 'hidden', name: 'yu', value: this.props.yu}),
                    React.DOM.input({
                        type: 'hidden',
                        name: 'retpath',
                        value: 'https://' + window.location.host + '/auth/login-status.html'
                    }),
                    React.DOM.button(null, 'Сделать основным')
                )
            ),
            React.DOM.td(
                null,
                React.DOM.form(
                    {action: '/passport?mode=embeddedauth', method: 'POST', target: 'authiframe'},
                    React.DOM.input({type: 'hidden', name: 'action', value: 'logout'}),
                    React.DOM.input({type: 'hidden', name: 'uid', value: this.props.uid}),
                    React.DOM.input({type: 'hidden', name: 'yu', value: this.props.yu}),
                    React.DOM.input({
                        type: 'hidden',
                        name: 'retpath',
                        value: 'https://' + window.location.host + '/auth/login-status.html'
                    }),
                    React.DOM.button(null, 'Разлогин')
                )
            )
        );
    }
});

var Message = React.createClass({
    displayName: 'Message',
    render: function() {
        return React.DOM.div({className: 'msg'}, this.props.msg_text);
    }
});

var Captcha = React.createClass({
    displayName: 'Captcha',
    render: function() {
        return React.DOM.div(
            {className: this.props.url !== null ? 'show' : 'hide'},
            React.DOM.table(
                null,
                React.DOM.tr(
                    null,
                    React.DOM.td(null, React.DOM.input({placeholder: 'Капча:', type: 'text', name: 'captcha_answer'})),
                    React.DOM.td(null, React.DOM.img({src: this.props.url}))
                )
            )
        );
    }
});

React.renderComponent(UserBox({url: '/auth/accounts.json', pollInterval: 2000}), document.getElementById('content'));
