/**
 * @jsx React.DOM
 */
// The above declaration must remain intact at the top of the script.
// Your code here

  var UserBox = React.createClass({
    loadUsersFromServer: function() {
      $.ajax({
        url: this.props.url,
        dataType: 'json',
        success: function(data) {
          this.setState({
              users: data.users,
              default_uid: data.default_uid,
              yu: (function(){
                  var cookiesArr = document.cookie.split(';');
                  var _cookies = {};
                  cookiesArr.forEach(function(item) {
                      var split = item.split('=');
                      _cookies[split.shift().trim()] = split.join('=');
                  });

                  return _cookies['yandexuid'] || '';
              })()
          });
        }.bind(this),
        error: function(xhr, status, err) {
          console.error(this.props.url, status, err.toString());
        }.bind(this)
      });
    },
    getInitialState: function() {
      return {users: [], default_uid: null, idkey: null, captcha_url: null};
    },
    handleRefresh: function(data) {
      var self = this;
      var msg = /.*status=([^&]*)(&.*)?/.exec(data.msg_text);
      var url = /.*url=([^&]*)(&.*)?/.exec(data.msg_text);
      var idkey = /.*idkey=([^&]*)(&.*)?/.exec(data.msg_text);
      var captcha_url = /.*captcha_url=([^&]*)(&.*)?/.exec(data.msg_text);
      msg = msg && msg[1];

      $("input[name='password'], input[name='captcha_answer']").val('');

      if (idkey) {
          self.setState({idkey: idkey[1]});
      } else {
          self.setState({idkey: null});
      }
      if (captcha_url) {
          self.setState({captcha_url: decodeURIComponent(captcha_url[1])});
      } else {
          self.setState({captcha_url: null});
      }
      if (msg === 'ok') {
          self.setState({msg_text: ''});
      } else {
          self.setState({msg_text: msg});
      }
      if (msg === 'other') {
          url = url && url[1];
          top.location = decodeURIComponent(url);
      }
      self.loadUsersFromServer();
    },
    componentWillMount: function() {
     var self = this;
      window.response = function(url){
          self.handleRefresh({msg_text: url});
      }
      window.addEventListener("message", function receiveMessage(event) {
          self.handleRefresh({msg_text: JSON.parse(event.data)['async-auth']});
      },false);
      //setInterval(this.loadUsersFromServer, this.props.pollInterval);
      self.loadUsersFromServer();
    },
    render: function() {
      return (
        <div className="userBox">
          <h2>Добавить:</h2>
          <form className="loginForm" action="/passport?mode=embeddedauth" method="POST" target="authiframe">
              <table>
              <tr>
              <td>
                  <input type="hidden" name="retpath" value={'https://' +  window.location.host + '/auth/login-status.html'} />
                  <input type="hidden" name="idkey" value={this.state.idkey} />
                  <input type="hidden" name="twoweeks" value='1' />
                  <input type="text" name="login" placeholder="Логин:" />
              </td>
              <td><input type="password" name="password" placeholder="Пароль:" /></td>
              <td><button>Добавить</button></td>
              </tr>
              <tr><td colSpan="3">
                  <label>
                  <input type="checkbox" name="twoweeks" value='0' /> Чужой компьютер
                  </label>
              </td></tr>
              </table>
              <Captcha url={this.state.captcha_url} />
          </form>
          <h2>Пользователи в куке:</h2>
          <UserList onRefresh={this.handleRefresh}  users={this.state.users} default_uid={this.state.default_uid} yu={this.state.yu} />
          <Message msg_text={this.state.msg_text} />
        </div>
      );
    }
  });

  var UserList = React.createClass({
    render: function() {
      var default_uid = this.props.default_uid;
      var yu = this.props.yu;
      var userNodes = this.props.users && this.props.users.map(function (user) {
        return <User key={user.uid && user.uid.value} login={user.login} display_name={user.display_name && user.display_name.name} uid={user.uid && user.uid.value} is_default={user.uid && user.uid.value == default_uid ? '1' : '0'} secure={String(user.auth && user.auth.secure)} password_age={user.auth && user.auth.password_verification_age} social_profile_id={user.auth && user.auth.social && user.auth.social.profile_id} status={user.status && user.status.value} yu={yu} />
      });
      return (
        <div className="userList">
        <table className="user">
            <thead>
            <tr>
                <th>login</th>
                <th>uid</th>
                <th>display name</th>
                <th>secure</th>
                <th>password age</th>
                <th>social profile id</th>
                <th>status</th>
                <th></th>
                <th></th>
            </tr>
            </thead>
           {userNodes}
        </table>
        </div>
      );
    }
  });

  var User = React.createClass({
    render: function() {
      return (
          <tr className={this.props.is_default == '1' ? 'default' : ''}>
            <td>
            {this.props.login}
            </td>
            <td>
            {this.props.uid}
            </td>
            <td>
            {this.props.display_name}
            </td>
            <td>
            {this.props.secure}
            </td>
            <td>
            {this.props.password_age}
            </td>
            <td>
            {this.props.social_profile_id}
            </td>
            <td>
            {this.props.status}
            </td>
            <td>
              <form action="/passport?mode=embeddedauth" method="POST" target="authiframe">
                  <input type="hidden" name="action" value="change_default" />
                  <input type="hidden" name="uid" value={this.props.uid} />
                  <input type="hidden" name="yu" value={this.props.yu} />
                  <input type="hidden" name="retpath" value={'https://' +  window.location.host + '/auth/login-status.html'} />
                  <button>Сделать основным</button>
              </form>
            </td>
            <td>
              <form action="/passport?mode=embeddedauth" method="POST" target="authiframe">
                  <input type="hidden" name="action" value="logout" />
                  <input type="hidden" name="uid" value={this.props.uid} />
                  <input type="hidden" name="yu" value={this.props.yu} />
                  <input type="hidden" name="retpath" value={'https://' +  window.location.host + '/auth/login-status.html'} />
                  <button>Разлогин</button>
              </form>
          </td>
          </tr>
      );
    }
  });

  var Message = React.createClass({
    render: function() {
      return (
          <div className='msg'>
              {this.props.msg_text}
          </div>
      );
    }
  });

  var Captcha = React.createClass({
    render: function() {
      return (
          <div className={this.props.url !== null ? "show" : "hide"}>
              <table>
              <tr>
              <td>
              <input placeholder="Капча:" type="text" name="captcha_answer" />
              </td>
              <td>
              <img src={this.props.url} />
              </td>
              </tr>
              </table>
          </div>
      );
    }
  });

  React.renderComponent(
    <UserBox url='/auth/accounts.json' pollInterval={2000} />,
    document.getElementById('content')
  );



