// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */

$(function() {
    passport.block('magic', {
        events: {
            'click .js-enable-inputs span': 'toggleOTP',
            'click .js-login-bt': 'stopPoll'
        },

        track_id: $('#track_id').val(),
        csrf_token: $('#csrf_token').val(),

        _viewName: null,
        _inputsEnabled: false,
        _interval: 300,
        _add_user_link: null,

        _errorIds: {
            'internal-exception': {
                msg: i18n('%ErrorsTexts.internal'),
                mend: i18n('%crap')
            },
            'password.not_matched': {
                msg: i18n('%ErrorsTexts.badlog_2fa'),
                mend: i18n('%creg_misspasswd_2fa')
            },
            'account.not_found': {
                msg: i18n('%ErrorsTexts.deleted'),
                mend: i18n('%deleted')
            },
            'account.disabled_on_deletion': {
                msg: i18n('%ErrorsTexts.deleted'),
                mend: i18n('%deleted')
            },
            'account.disabled_with_money': {
                msg: i18n('%ErrorsTexts.deleted'),
                mend: i18n('%deleted')
            },
            'account.disabled': {
                msg: i18n('%ErrorsTexts.badlog_blocked'),
                mend: i18n('%disabled')
            },
            // 'captcha.required': {
            //     msg: i18n('%ErrorsTexts.badlog'),
            //     mend: i18n('%creg_misspasswd')
            // },
            'account.registration_limited': {
                msg: i18n('%import.sms_limit_exceeded')
            },
            internal: {
                msg: i18n('%ErrorsTexts.internal'),
                mend: i18n('%crap')
            },
            'sessionid.overflow': {
                msg: i18n('%ErrorsTexts.sessionidoverflow'),
                mend: i18n('%MendTexts.sessionidoverflow')
            },
            'session.invalid': {
                msg: i18n('%session_invalid'),
                mend: i18n('%session_invalid_mend')
            },
            'account.compromised': {
                msg: i18n('%ErrorsTexts.account_compromised')
            }
        },

        _showError: function(code) {
            var self = this;

            if (!this._errorIds[code]) {
                return;
            }

            $('.js-messages').html(
                yr.run(
                    'auth.magic',
                    {
                        errors: [
                            {
                                code: code,
                                msg: self._errorIds[code].msg || '',
                                mend: self._errorIds[code].mend || ''
                            }
                        ]
                    },
                    'error-isle'
                )
            );
        },

        _showCaptcha: function(captcha) {
            $('.js-domik-captcha').html(
                yr.run(
                    'auth.magic',
                    {
                        static: captcha.static,
                        control: [captcha]
                    },
                    'captcha'
                )
            );

            this._rebindCaptchaEvents();
            this._showCaptchaMsg();
            this._hideMagic();
        },

        _showCaptchaMsg: function() {
            this.$('.js-captcha__msg').html(
                yr.run(
                    'auth.magic',
                    {
                        captchaMsg: i18n('%magic.captcha_msg')
                    },
                    'captcha-msg'
                )
            );
        },

        _rebindCaptchaEvents: function() {
            passport.block('captcha').construct($('*[data-block="p-control_captcha"]'));
            passport.validator.register(passport.ensureBlock('control_captcha'));
        },

        _hideMagic: function() {
            this.$('.js-magic-container').remove();
        },

        toggleOTP: function() {
            if (this._inputsEnabled) {
                return;
            }

            this.$('.js-enable-inputs').addClass('enable-inputs-link__hidden');
            this.$('.inputs').removeClass('inputs__hidden');
            this._inputsEnabled = true;

            this.$('input:visible')
                .first()
                .focus();
        },

        restartPolling: function() {
            var self = this;

            clearTimeout(window.pollTimeout);
            window.pollTimeout = setTimeout(function() {
                self.poll();
            }, self._interval);
        },

        poll: function() {
            var self = this;

            var req = $.ajax('/auth/magic/status/', {
                data: {
                    track_id: self.track_id,
                    csrf_token: self.csrf_token
                },
                dataType: 'json',
                type: 'POST'
            });

            req.done(function(results) {
                if (results.status === 'ok' && results.state === 'otp_auth_finished') {
                    window.location.href = '/auth/finish/?track_id=' + self.track_id;
                    return;
                }

                if (results.errors) {
                    self._showError(results.errors[0]);
                    self.toggleOTP();

                    if (results.errors.indexOf('captcha.required') !== -1) {
                        self._showCaptcha(results.captcha);
                        return;
                    }
                }

                self.restartPolling();
            });
        },

        stopPoll: function() {
            clearTimeout(window.pollTimeout);
        },

        init: function() {
            var self = this;

            self._add_user_link = $('.js-add_user_link');

            setTimeout(function() {
                self._interval = 1000;
            }, 60 * 1000);

            setTimeout(function() {
                location.href = self._add_user_link.attr('href');
            }, 60 * 1000 * 10);

            this.restartPolling();
        }
    });

    nb.init();
    passport.init();
    $('input:visible')
        .first()
        .focus();
});
