import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Footer} from '@components/Footer/Footer.jsx';
import OneDomik from '@blocks/one_domik/one_domik.jsx';

class App extends Component {
    render() {
        const {common, settings, customs} = this.props;

        return (
            <div className='passport-Page-Body'>
                {Boolean(!settings.ua.isMobile && customs.display !== 'touch') && (
                    <React.Fragment>
                        <div className={`passport-Page-Background passp-bg_${common.bgNumber}`} />
                        <span className='passport-Page-Helper' />
                    </React.Fragment>
                )}
                <OneDomik />
                {Boolean(!customs.minimal) && (
                    <footer className='passport-Page-Footer'>
                        <Footer
                            loadCustomsStyles={true}
                            langlist={settings.langlist}
                            env={settings.env}
                            help={settings.help}
                            tld={settings.tld}
                            language={settings.lang}
                        />
                    </footer>
                )}
            </div>
        );
    }
}

App.propTypes = {
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool
        }).isRequired,
        tld: PropTypes.string,
        env: PropTypes.string,
        help: PropTypes.string,
        lang: PropTypes.string,
        langlist: PropTypes.array
    }).isRequred,
    customs: PropTypes.shape({
        minimal: PropTypes.bool,
        display: PropTypes.string
    }).isRegister,
    common: PropTypes.shape({
        bgNumber: PropTypes.number
    }).isRequired
};

export default connect((state) => state)(App);
