import {combineReducers} from 'redux';
import thunkMiddleware from 'redux-thunk';
import {redirect} from './middlewares.js';
import {createStore, applyMiddleware, compose} from 'redux';
import one_domik from '@blocks/one_domik/reducers';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState) {
    return createStore(
        combineReducers({
            common,
            one_domik,
            settings,
            captcha,
            metrics,
            monitoring,
            customs,
            social
        }),
        initialState,
        compose(applyMiddleware(thunkMiddleware, redirect), devTools)
    );
}

function settings(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function social(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function metrics(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function monitoring(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}

function customs(state = {}, action) {
    switch (action.type) {
        default:
            return state;
    }
}
