// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/auth.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/magic/magic.js */

passport.block('password-auth', 'control', {
    needsServerValidation: false,

    events: {
        'keyup .js-passwd-field': 'toggleHint'
    },

    validate: function(supressError) {
        if (this.isEmpty()) {
            this.validationResult(false, 'missingvalue', supressError);
            return;
        }

        if (passport.util.checkPassword(this.val())) {
            this.validationResult(true, 'lang', supressError);
            return;
        }

        this.validationResult(true, null, true);
        this.error();
    }
});

['password-auth'].forEach(function(control) {
    var block = passport.block(control);

    block.toggleHint = function(event) {
        var elem = event.currentTarget;
        var hint = this.$('.js-' + elem.id + '-control-hint');

        if (!hint) {
            return;
        }

        if (elem.value) {
            hint.addClass('g-hidden');
        } else {
            hint.removeClass('g-hidden');
        }
    };

    block.error = function(code) {
        if (['login-auth', 'password-auth'].indexOf(control) !== -1 && (passport.isTouch || passport.isTablet)) {
            if (code) {
                this.$ctrl.addClass('domik-input__invalid');
            } else {
                this.$ctrl.removeClass('domik-input__invalid');
            }

            return;
        }

        this.$('.domik-error-' + this.id).removeClass('b-popup_open');
        if (code) {
            this.$('.domik-error-' + this.id + '_' + code).addClass('b-popup_open');
        }
    };

    if (control === 'login-auth') {
        block.updateTimeout = 0;
    } else {
        block.updateTimeout = 50;
    }

    passport.mixins.validateOnFocusout(block);
});

passport.block('confirm', {
    events: {
        'click .js-stop-magic': 'stopMagic',
        'click .domik-qr-code': 'switchToMagic',
        'correct.captcha': 'proceedCaptcha',
        'needCaptcha.magic': 'addCaptcha',
        'genericError.magic': 'stopMagic'
    },

    _magic: null,
    _domik: null,
    _messages: null,
    _magicBlock: null,
    _captchaBlock: null,

    _captchaActive: false,
    _magicActive: false,

    stopMagic: function() {
        var self = this;

        self._magic.hide();
        self._domik.show();
        self._magicBlock.stop();
        self._magicActive = false;
        return false;
    },

    switchToMagic: function() {
        var self = this;

        self._domik.hide();
        self._messages.empty(true);

        if (self._magic === null) {
            self.initMagic();
        } else {
            self._magic.show();
            self._magicBlock.restart();
        }

        self._magicActive = true;

        return false;
    },

    proceedCaptcha: function() {
        if (!this._captchaActive) {
            return;
        }

        this._captchaActive = false;

        this._captchaBlock.closeCaptcha();

        if (this._magicActive) {
            this._magicBlock.restart();
        }
    },

    initMagic: function() {
        var self = this;

        self.$el.append($('#magicTemplate').html());

        self._magic = $('.magic');

        passport.block('magic').init({
            handle: '/auth/verify/magic/status/'
        });
    },

    addCaptcha: function(event, captcha) {
        var self = this;

        if (self._captchaActive) {
            return;
        }

        self._captchaActive = true;

        if (!self._captchaBlock) {
            delete captcha.key;
            delete captcha.image_url;

            $('body').append(
                yr.run(
                    'auth.verify',
                    {
                        static: captcha.static,
                        control: [captcha]
                    },
                    'captcha'
                )
            );

            $('*[data-block=control_captcha]').each(function() {
                var block = passport.ensureBlock($(this).attr('data-block'));

                if (block) {
                    block.construct(this, $(this).data('options'));
                    // eslint-disable-next-line no-console
                    console.log('Block "' + block.id + '" inited.');

                    if (block.isControl) {
                        passport.validator.register(block);
                    }
                }
            });
            self._captchaBlock = passport.block('captcha');
            self._captchaBlock.updateTimeout = 0;
        }

        self._captchaBlock.enableCaptcha();
    },

    init: function() {
        var self = this;

        self._domik = $('.verify-state_password');
        self._messages = $('.js-messages');

        self._magicBlock = passport.block('magic');

        passport.block('captcha').inited.done(function(captcha) {
            self._captchaBlock = captcha;
            self._captchaBlock.updateTimeout = 0;
            self._captchaBlock.enableCaptcha();
            self._captchaActive = true;
        });
    }
});

$(function() {
    passport.block('submit').onValid = function() {
        this.onSubmit();
        this.$el.closest('form').submit();
        this.$('button[type=submit]').attr('disabled', true);
    };

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    var isTouch = $('html').hasClass('is-touch') || $('html').hasClass('is-tablet');

    if (!isTouch) {
        $('input:visible')
            .first()
            .focus();
    }
});
