import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import Header from '@components/Header/Header.jsx';
import {Footer} from '@components/Footer/Footer.jsx';
import {NoJS} from '@components/NoJS';

import UserApprove from './userapprove.jsx';

class App extends Component {
    render() {
        const {settings, footer} = this.props;

        return (
            <div className='layout-inner'>
                <NoJS />
                <Header />
                <UserApprove />
                <Footer {...settings} {...footer} />
            </div>
        );
    }
}

App.propTypes = {
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    header: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired
};

export default connect((state) => state)(App);
