// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */
var headerMetrics;

function sendMetric(params) {
    if (headerMetrics) {
        passport.Metrika.count(headerMetrics.concat(params));
    }
}

passport.block('twofa-app-link-via-sms', 'control', {
    isRequired: false,
    needsServerValidation: false,
    updateTimeout: 0,

    events: {
        click: 'sendSms'
    },

    init: function() {
        this.button = nb.block(this.$('.js-twofa-app-link-via-sms-button').get(0));
    },

    toggleSendButton: function(enabled) {
        this.$('.js-twofa-app-link-via-sms-button').toggleClass('twofa-app-link-via-sms-transparent', enabled);

        if (enabled) {
            this.button.disable();
        } else {
            this.button.enable();
        }
    },

    toggleSentText: function(shown) {
        this.$('.js-twofa-app-link-via-sms-sent').toggleClass('twofa-app-link-via-sms-transparent', !shown);
    },

    scheduleFeedbackStop: function() {
        var that = this;

        setTimeout(function() {
            that.toggleSendButton(false);
            that.toggleSentText(false);
        }, 30000); //In 30 seconds
    },

    sendSms: function() {
        var that = this;

        this.toggleSendButton(true);
        passport.api.request('twofa-app-link-via-sms', {}).done(function(result) {
            if (result.status === 'ok') {
                that.toggleSentText(true);
                that.scheduleFeedbackStop(); //May send again
                that.error();
            } else {
                //There was an error
                that.toggleSentText(false);
                that.error(result.error);
            }
        });
    }
});

passport.block('twofa-entry-confirmnew', {
    events: {
        'click .js-twofa-entry-confirmnew-toggle': 'expand'
    },

    expand: function() {
        this.$('.js-twofa-entry-confirmnew-extras').removeClass('g-hidden');
        this.$('.js-twofa-entry-confirmnew-toggle').addClass('g-hidden');
    }
});

passport.block('twofa-secret-code', {
    events: {
        'toggle.twofa-secret-toggler': 'toggle'
    },

    toggle: function() {
        this.$('.js-twofa-secret-code-view').toggleClass('g-hidden');
    }
});

passport.block('twofa-secret-toggler', {
    events: {
        'click .js-twofa-secret-toggler-text': 'toggle'
    },

    toggle: function() {
        $('.js-twofa-secret-toggler-text, .js-get-secret').toggleClass('g-hidden');
        this.emit('toggle');
    }
});

passport.block('twofa-pin-entry', 'control', {
    controlSelector: '.twofa-pin-entry-input',
    canSwitchInputType: true,

    events: {
        'click .js-toggle-visibility': 'toggleVisibility'
    },

    validationCallback: function(data, suppressError) {
        var isValid = data.status === 'valid';
        var errors = isValid ? null : passport.validator.getErrorCode(data.errors);

        this.validationResult(isValid, errors, suppressError);
        return isValid;
    },

    toggleVisibility: function(event) {
        event.preventDefault();

        if (!this.canSwitchInputType) {
            return;
        }

        var currentType = this.$ctrl.attr('type');
        var newType = currentType === 'password' ? 'tel' : 'password';

        this.toggleControlTogglerState();
        this.$ctrl.attr({type: newType}).focus();
        this.emit('visibilityChange', newType);
    },

    toggleControlTogglerState: function() {
        this.$('.js-toggle-visibility').toggleClass('g-hidden');
    },

    init: function() {
        passport.block('password').checkIfCanSwitchFieldType.call(this);
        if ($('html').hasClass('is-touch')) {
            this.canSwitchInputType = false;
        }
        if (!this.canSwitchInputType) {
            this.$('.js-toggle-visibility').remove();
        }
    }
});

passport.block('twofa-pin-entry-confirm', 'control', {
    needsServerValidation: false,
    controlSelector: '.twofa-pin-entry-confirm-input',

    events: {
        'update.twofa-pin-entry': 'onPinUpdate',
        'visibilityChange.twofa-pin-entry': 'clearValue',
        'focus .js-twofa-pin-entry-confirm-input': 'togglePinVisibility'
    },

    clearValue: function() {
        this.val('');
    },

    togglePinVisibility: function() {
        if (!this._pin.canSwitchInputType) {
            return;
        }

        this._pin.$ctrl.attr({type: 'password'});
        this._pin.toggleControlTogglerState();
    },

    onPinUpdate: function() {
        this.validate(true);
    },

    validate: function(silent) {
        var currentPin = this._pin.val().trim();
        var confirmPin = this.val().trim();

        if (this.isEmpty()) {
            this.validationResult(false, 'missingvalue', silent);
            return;
        }

        if (confirmPin && currentPin && confirmPin !== currentPin) {
            this.validationResult(false, 'didnotmatch');
            return;
        }

        this.validationResult(true, null);
        return;
    },

    init: function() {
        this._pin = passport.block('twofa-pin-entry');
    }
});

passport.block('twofa-otp-entry', 'control', {
    needsServerValidation: false,
    validateSync: function() {
        if (!/^[a-z\s]*$/i.test(this.val())) {
            return ['prohibitedsymbols'];
        }
    }
});

var generateStatedSubmit = function(blockName, dependencyName) {
    var block = passport.block(blockName, 'submit', {
        controlsToCheck: Array.isArray(dependencyName) ? dependencyName : [dependencyName],
        init: function() {
            this.nbctrl = nb.block(this.$('[data-nb]').get(0));
        },

        toggleState: function() {
            if (this.id === 'twofa-password-submit') {
                return;
            }

            var isValid = true;

            this.controlsToCheck.forEach(function(block) {
                if (!passport.validator.store[block] && passport.validator.store[block] !== undefined) {
                    isValid = false;
                }
            });

            if (isValid) {
                this.nbctrl.enable();
            } else {
                this.nbctrl.disable();
            }
        }
    });

    block.events = $.extend({}, block.events);
    [].concat(dependencyName).forEach(function(name) {
        block.events['validation.' + name] = 'toggleState';
    });
};

generateStatedSubmit('twofa-pin-submit', ['twofa-pin-entry', 'twofa-pin-entry-confirm']);
generateStatedSubmit('twofa-otp-submit', 'twofa-otp-entry');
generateStatedSubmit('twofa-password-submit', ['current-password', 'captcha']);

(function() {
    var currentPassword = passport.block('current-password');

    currentPassword.updateTimeout = 50;
    delete currentPassword.events.focusout;
})();

(function() {
    var phoneconfirm = passport.block('phone-confirm');

    phoneconfirm.phoneConfirmed = function() {
        var a = document.createElement('a');

        a.href = window.location.href;
        a.pathname = a.pathname + '/pin';
        a.search = '?track_id=' + passport.track_id;

        window.location.assign(a.href);
    };
})();

passport.block('get-app-popup', {
    events: {
        'click .js-get-app-popup-trigger': 'showPopup'
    },

    showPopup: function() {
        if (!this.popup) {
            return;
        }

        this.popup.open({
            where: '.js-get-app-popup-box',
            autofocus: false
        });
    },

    init: function() {
        this.popup = nb.block(this.$('.js-' + this.id).get(0));

        if (!passport.isTouch && !passport.isTablet) {
            this.showPopup();
        }
    }
});

$(function() {
    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    $('input:visible:enabled')
        .first()
        .focus();

    // Ваш код здесь
    headerMetrics = ['Настройка двухфакторной аутентификации'];
    sendMetric(['показ страницы', window.location.pathname]);
});
