// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

passport.block('twofa-secret-code', {
    events: {
        'toggle.twofa-secret-toggler': 'toggle'
    },

    toggle: function() {
        this.$('.js-twofa-secret-code-view').toggleClass('g-hidden');
    }
});

passport.block('twofa-secret-toggler', {
    events: {
        'click .js-twofa-secret-toggler-text': 'toggle'
    },

    toggle: function() {
        $('.js-twofa-secret-toggler-text, .js-get-secret').toggleClass('g-hidden');
        this.emit('toggle');
    }
});

passport.block('twofa-otp-entry', 'control', {
    needsServerValidation: false,
    validateSync: function() {
        if (!/^[a-z\s]*$/i.test(this.val())) {
            return ['prohibitedsymbols'];
        }
    }
});

var generateStatedSubmit = function(blockName, dependencyName) {
    var block = passport.block(blockName, 'submit', {
        controlsToCheck: Array.isArray(dependencyName) ? dependencyName : [dependencyName],
        init: function() {
            this.nbctrl = nb.block(this.$('[data-nb]').get(0));
        },

        toggleState: function() {
            if (this.id === 'twofa-password-submit') {
                return;
            }

            var isValid = true;

            this.controlsToCheck.forEach(function(block) {
                if (!passport.validator.store[block] && passport.validator.store[block] !== undefined) {
                    isValid = false;
                }
            });

            if (isValid) {
                this.nbctrl.enable();
            } else {
                this.nbctrl.disable();
            }
        }
    });

    block.events = $.extend({}, block.events);
    [].concat(dependencyName).forEach(function(name) {
        block.events['validation.' + name] = 'toggleState';
    });
};

generateStatedSubmit('twofa-otp-submit', 'twofa-otp-entry');

$(function() {
    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    nb.init();
});
