window.ZeroClipboard = null;

try {
    /* jshint noempty:false */
    /* borschik:include:{{RELATIVEROOT}}/node_modules/zeroclipboard/dist/ZeroClipboard.min.js */
} catch (e) {
    // empty
}

/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:appwd.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

passport.mixins.nanoislandizeInputs();

var headerMetrics;

function sendMetric(params) {
    if (headerMetrics) {
        passport.Metrika.count(headerMetrics.concat(params));
    }
}

if (/MSIE|Trident/.test(window.navigator.userAgent) && ZeroClipboard) {
    //PASSP-10775 — Копирование пароля приложений вешает IE10-11
    $.widget('ui.dialog', $.ui.dialog, {
        _allowInteraction: function(event) {
            return (
                this._super.apply(this, arguments) ||
                $(event.target).closest('.' + ZeroClipboard.config('containerClass')).length
            );
        }
    });
}

passport.block('appPassword-create', 'block', {
    events: {
        'validation.appPassword-create-custom-name': 'onCustomNameChange',
        'click button': 'submit'
    },

    init: function() {
        var nbSubmitButton = nb.block(this.$('.js-appPassword-create-submit').get(0));

        this.nbSubmitButton = nbSubmitButton;

        var serviceSelect = this.$('.js-appPassword-create-scope');
        var customNameField = passport.block('appPassword-create-custom-name');

        this.updateSubmitState = function() {
            var serviceSelected = serviceSelect.val() !== 'none';
            var customNameField = passport.validator.store['appPassword-create-custom-name'];

            if (serviceSelected && customNameField) {
                nbSubmitButton.enable();
            } else {
                nbSubmitButton.disable();
            }
        };

        serviceSelect.on('change', this.updateSubmitState);

        this.getService = function() {
            return serviceSelect.val();
        };
        this.getOs = function() {
            return customNameField.val();
        };
    },

    onCustomNameChange: function() {
        var that = this;

        setTimeout(function() {
            //TODO: hackety hack
            that.updateSubmitState();
        }, 0);
    },

    redirectToAuth: function(path) {
        var a = document.createElement('a');

        a.href = window.location.href;
        a.pathname = path;
        a.search = 'retpath=' + encodeURIComponent(window.location.href);
        window.location.href = a.href;
    },

    submit: function() {
        this.nbSubmitButton.disable();
        var that = this;
        var name = this.getOs();

        passport.api
            .request('access/token/new', {
                name: name,
                scope: this.getService(),
                csrf: this.$('.js-appPassword-create-csrf').val()
            })
            .done(function(response) {
                var responseError =
                    response && response.status && response.status === 'error' && Array.isArray(response.errors);

                if (
                    responseError &&
                    (response.errors.indexOf('sslsession.required') > -1 ||
                        response.errors.indexOf('session.required') > -1)
                ) {
                    that.redirectToAuth('/auth/secure');
                } else if (responseError && response.errors.indexOf('password.required') > -1) {
                    that.redirectToAuth('/auth/verify');
                } else if (responseError && response.errors.indexOf('token.limit_exceeded') > -1) {
                    $('.create-password__error').removeClass('g-hidden');
                } else {
                    passport.block('apptoken-popup').open(response.clientSlug, name, response.alias);
                }
            });
    }
});

passport.block('appPassword-create-custom-name', 'control', {
    needsServerValidation: false,

    show: function() {
        this.$el.removeClass('appPassword-create-hidden');
        this.nbctrl.focus();
    },

    validateSync: function() {
        if (this.val().length > 100) {
            return 'toolong';
        }
    },

    error: function(err) {
        err = err ? [].concat(err) : null;
        if (err && err.indexOf('missingvalue') > -1) {
            err = null; //No missingvalue error for this control
        }

        this.parent.error.call(this, err);
    }
});

passport.block('apptoken-popup', {
    init: function() {
        this.popup = nb.block(this.$('.apptoken-popup-popup').get(0));
        this.doneButton = nb.block(this.$('.js-apptoken-popup-done-button').get(0));

        this.doneButton.on('click', function() {
            window.location.reload();
        });

        if (!ZeroClipboard) {
            return;
        }

        var $copyFeedback = this.$('.js-apptoken-popup-alias-copied');

        ZeroClipboard.config({
            swfPath: passport.staticPath + 'js/ZeroClipboard.swf'
        });

        var $clippy = this.$('.js-apptoken-popup-alias-clippy');
        var clipboard = new ZeroClipboard($clippy);

        clipboard.on('copy', function() {
            var hiddenClass = 'apptoken-popup-alias-copied-hidden';

            $copyFeedback.removeClass(hiddenClass);
            setTimeout(function() {
                $copyFeedback.addClass(hiddenClass);
            }, 2000);
        });

        var clippyHiddenClass = 'apptoken-popup-alias-clippy-hidden';

        clipboard.on('error', function() {
            $clippy.addClass(clippyHiddenClass);
        });
        clipboard.on('ready', function() {
            $clippy.removeClass(clippyHiddenClass);
        });
    },

    open: function(slug, device, alias) {
        this.$('.js-apptoken-popup-alias-text').text(alias);
        this.$('.js-apptoken-popup-alias-clippy').attr('data-clipboard-text', alias);
        this.$('.js-apptoken-popup-title-device').text(device);

        var slugHiddenClass = 'apptoken-popup-title-slug-hidden';

        this.$('.js-apptoken-popup-title-slug').addClass(slugHiddenClass);
        this.$('.js-apptoken-popup-title-slug-' + slug).removeClass(slugHiddenClass);

        this.popup.open({
            how: {
                autoclose: false
            }
        });
    }
});

passport.block('twofa-toggler', 'control', {
    needsServerValidation: false,
    init: function() {
        var that = this;
        var isAppPwdChecked;
        var isAppPwdDisabled;
        var appPwdToggler = passport.block('appPwd-toggler');

        this._initiallyOn = Boolean(this.$el.data('on'));

        setTimeout(function() {
            //TODO: hackety hack-hack :(
            that.nbctrl.on('nb-changed', function() {
                isAppPwdChecked = appPwdToggler.nbctrl && appPwdToggler.nbctrl.isChecked();
                isAppPwdDisabled = $('.app-passwords-off').length;
                if (!that.nbctrl.isChecked()) {
                    if (that._initiallyOn) {
                        that._disable2fa();
                    } else {
                        that._closePromo();
                        if (!isAppPwdChecked && !isAppPwdDisabled && appPwdToggler.nbctrl) {
                            appPwdToggler.nbctrl.check();
                        }
                        sendMetric(['выключить тумблер двухфакторной авторизации']);
                    }
                } else {
                    that._openPromo();
                    if (isAppPwdChecked && isAppPwdDisabled) {
                        if (appPwdToggler.nbctrl) {
                            appPwdToggler.nbctrl.uncheck();
                        }
                    } else if (!isAppPwdChecked && !isAppPwdDisabled) {
                        if (appPwdToggler.nbctrl) {
                            appPwdToggler.nbctrl.check();
                        }
                    }
                    appPwdToggler.closePromo();
                    sendMetric(['включить тумблер двухфакторной авторизации']);
                }
            });
        }, 1);
    },

    _disable2fa: function() {
        window.location.href = '/profile/access/2fa/disable';
    },

    toggleControlEnabled: function(shouldBeEnabled) {
        if (shouldBeEnabled) {
            this.nbctrl.enable();
            nb.block($('.access-webaccess-twofa-promo-button').get(0)).enable();
        } else {
            nb.block($('.access-webaccess-twofa-promo-button').get(0)).disable();
            this.nbctrl.uncheck();
            this.nbctrl.disable();
            this._closePromo();
        }

        this.$el
            .parent()
            .find('.access-webaccess-label-text') //TODO: hackety hack-hack :(
            .toggleClass('access-webaccess-twofa-unavailable-disabled', !shouldBeEnabled);
    },

    _openPromo: function() {
        $('.js-access-webaccess-twofa-promo').removeClass('access-webaccess-twofa-promo-collapsed');

        if (passport.isTouch) {
            $('html, body').animate(
                {
                    scrollTop: $('.js-anchor').offset().top
                },
                'slow'
            );
        }
    },

    _closePromo: function() {
        $('.js-access-webaccess-twofa-promo').addClass('access-webaccess-twofa-promo-collapsed');
    }
});

passport.block('promo-video-popup', {
    events: {
        'click .js-promo-button-play': 'showVideo',
        'click .js-promo-paranja, click .js-promo-video-closer': 'hideVideo'
    },

    stopPropagation: function(event) {
        event.stopPropagation();
    },

    showVideo: function() {
        this.toggleVisibility(true);
        this.video.attr('src', this.videoSource);
    },

    hideVideo: function() {
        this.toggleVisibility(false);
        this.video.removeAttr('src');
    },

    toggleVisibility: function(show) {
        this.paranja.toggleClass('g-hidden', !show);
    },

    init: function() {
        this.paranja = this.$('.js-promo-paranja');
        this.video = this.$('.js-promo-video');
        this.videoSource = this.video.data('src');
    }
});

passport.block('token-block', {
    events: {
        'click .js-token-toggle-i': 'toggleTokenInfoVisibility',
        click: 'showTokenInfo'
    },

    getParent: function(event) {
        if (!event) {
            return false;
        }

        return $(event.target).parents('.js-token');
    },

    showTokenInfo: function(event) {
        event.stopPropagation();

        var parent = this.getParent(event);

        if (!parent) {
            return;
        }

        parent.addClass('token_state_open');
    },

    toggleTokenInfoVisibility: function(event) {
        event.stopPropagation();

        var parent = this.getParent(event);

        if (!parent) {
            return;
        }

        parent.toggleClass('token_state_open');
    },

    showActiveToken: function() {
        var activeTokenId = $('.js-active-token-id').val();

        if (!activeTokenId) {
            return;
        }

        var activeTokenElement = $('.js-token[data-token-id="' + activeTokenId + '"]');

        if (!activeTokenElement.length) {
            return;
        }

        activeTokenElement.addClass('token_state_open active_token');

        $('html, body').animate(
            {
                scrollTop: activeTokenElement.offset().top
            },
            'slow'
        );
    }
});

$(function() {
    passport.init();
    var metricEvent = 'mousedown';

    if ('ontouchstart' in window) {
        metricEvent = 'touchstart';
    }

    $(document).on(metricEvent, '.access-webaccess-twofa-promo-button', function() {
        sendMetric(['начать настройку 2фа']);
    });

    $(document).on(metricEvent, '.js-metrics-access-password', function() {
        sendMetric(['сменить пароль']);
    });

    $(document).on(metricEvent, '.js-metrics-app_password-create-button', function() {
        sendMetric(['получить пароль приложения']);
    });

    $(document).on(metricEvent, '.js-metrics-app_access-delete-button', function() {
        sendMetric(['"удалить" приложение из списка программ с доступом к аккаунту']);
    });

    headerMetrics = ['Страница управления доступом'];
    sendMetric(['показ страницы']);

    $('.tokens-info-icon').click(function(event) {
        var popup = nb.block($(this).get(0));

        event.stopPropagation();
        popup.toggle();
    });

    $('.access-webaccess-twofa-unavailable-warning').click(function() {
        $('.access-webaccess-twofa-warning-wrapper').toggleClass('access-webaccess-twofa-warning-wrapper-collapsed');
    });

    passport.block('token-block').showActiveToken();
});
