// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

$(function() {
    passport.block('appPassword-creator', {
        appPasswordName: '',
        showCopyBtn: false,

        events: {
            'click .js-create-password': 'createAppPassword'
        },

        init: function() {
            var $copyFeedback = $('.app-password-copied');
            var $clippy = $('.js-copy-btn');

            try {
                document.execCommand('copy');
                this.showCopyBtn = true;
            } catch (err) {
                /* eslint no-empty: "error" */
                // continue regardless of error
            }

            if (!this.showCopyBtn) {
                $copyFeedback.addClass('g-hidden');
                $clippy.addClass('g-hidden');
            }
        },

        createAppPassword: function() {
            var passName = $('input#app_password_name')
                .val()
                .trim();
            var customName;
            var data = {
                csrf: $('#csrf').val(),
                scope: $('#scope').val(),
                name: ''
            };
            var appPassEnabled = $('#app_pass_enabled').val();
            var pwdReadyText = i18n('%access.copy_app_pwd');

            $('.js-create-password').addClass('is-disabled');

            if (passName) {
                customName = ' «' + passName + '»';
                this.appPasswordName = pwdReadyText.replace('%s', customName);
                data.name = passName;
            } else {
                this.appPasswordName = pwdReadyText.replace('%s', '');
            }

            if (appPassEnabled) {
                this.getAppPassword(data);
            } else {
                this.appPasswordsActivate(data);
            }
        },

        copyAppPassword: function() {
            var helperInput = document.querySelector('.helper-input');
            var $copyFeedback = $('.app-password-copied');

            helperInput.select();
            document.execCommand('copy');
            $copyFeedback.removeClass('app-password-copied-hidden');
            setTimeout(function() {
                $copyFeedback.addClass('app-password-copied-hidden');
            }, 2000);
        },

        getAppPassword: function(data) {
            var self = this;

            passport.api.request('access/token/new', data).done(function(response) {
                if (response && response.status && response.status === 'error') {
                    self.processErrors(response.errors);
                } else {
                    self.showAppPassword(response.alias);
                }
                $('.js-create-password').removeClass('is-disabled');
            });
        },

        showAppPassword: function(pass) {
            var copyBtn = document.querySelector('.js-copy-btn');

            if (copyBtn !== null) {
                copyBtn.addEventListener('click', this.copyAppPassword);
            }

            $('.helper-input').val(pass);
            $('.app-password-alias-text').text(pass);
            $('#pass_name').text(this.appPasswordName);
            $('.form-block').addClass('g-hidden');
            $('.app-password-done').removeClass('g-hidden');
        },

        appPasswordsActivate: function(data) {
            var self = this;
            var trackId = $('#track_id').val();

            passport.api
                .request(
                    'appPwdActivate',
                    {
                        track_id: trackId,
                        csrf_token: data.csrf
                    },
                    {
                        cache: false,
                        abortPrevious: true
                    }
                )
                .done(function(response) {
                    if (response.body && response.body.status === 'ok') {
                        self.getAppPassword(data);
                    }

                    if (response.errors) {
                        if (response.errors[0] === 'action.not_required') {
                            return self.getAppPassword(data);
                        }

                        self.processErrors(response.errors);
                    }
                });
        },

        processErrors: function(errors) {
            if (Array.isArray(errors)) {
                var a = document.createElement('a');
                var state = {
                    process: 'create app password',
                    enteredName: $('.app-password-name input').val(),
                    isAppPasswordsEnabled: Boolean($('#app_pass_enabled').val())
                };
                var retpath = window.location.href + '&track_id=' + passport.track_id;

                a.href = window.location.href;
                a.search = '?retpath=' + encodeURIComponent(retpath);
                if (errors.indexOf('sslsession.required') > -1) {
                    a.pathname = '/auth/secure';
                } else if (errors.indexOf('password.required') > -1) {
                    a.pathname = '/auth/verify';
                } else if (errors.indexOf('session.required') > -1) {
                    a.pathname = '/auth';
                }

                passport.api
                    .request(
                        'write-track',
                        {
                            track_id: passport.track_id,
                            frontend_state: JSON.stringify(state)
                        },
                        {
                            cache: false,
                            abortPrevious: true
                        }
                    )
                    .always(function() {
                        window.location.href = a.href;
                    });
            }
        }
    });

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    $('input:visible')
        .first()
        .focus();

    $('.show-text').click(function() {
        $('.note').addClass('show-all');
    });

    $('.hide-text').click(function() {
        $('.note').removeClass('show-all');
    });
});
