passport.block('appPwd-toggler', 'control', {
    needsServerValidation: false,
    init: function() {
        var twofaToggler = passport.block('twofa-toggler');
        var that = this;
        var isAppPasswordsEnabled;
        var isTwoFAChecked;

        that.csrf = $('body').data('csrf');

        that.track_id = passport.util.getUrlParams().track_id || '';
        setTimeout(function() {
            //TODO: hackety hack-hack :(
            that.nbctrl.on('nb-changed', function() {
                isAppPasswordsEnabled = !$('.app-passwords-off').length;
                isTwoFAChecked = twofaToggler.nbctrl.isChecked();
                if (isTwoFAChecked) {
                    twofaToggler.nbctrl.uncheck();
                }
                if (that.nbctrl.isChecked()) {
                    if (!isAppPasswordsEnabled) {
                        that.openPromo();
                        twofaToggler._closePromo();
                        passport.api.log('show_app_password_promo_enable');
                    } else {
                        that.closePromo();
                    }
                    sendMetric(['включить тумблер паролей приложений']);
                } else {
                    if (isAppPasswordsEnabled) {
                        that.openPromo();
                        twofaToggler._closePromo();
                        passport.api.log('show_app_password_promo_disable');
                    } else {
                        that.closePromo();
                    }
                    sendMetric(['выключить тумблер паролей приложений']);
                }
            });
        }, 1);

        if (!that.track_id) {
            that._getTrack();
        }
    },

    _getTrack: function() {
        var that = this;

        passport.api
            .request(
                'getTrackWithUid',
                {
                    track_id: that.track_id,
                    csrf_token: that.csrf
                },
                {
                    cache: false,
                    abortPrevious: true
                }
            )
            .done(function(response) {
                if (response && response.track_id) {
                    that.track_id = response.track_id;
                    if (window.location.hash === '#open_promo') {
                        window.location.hash = '';
                        that.openPromo();
                    }
                } else {
                    that._getTrack();
                }
            });
    },

    appPasswordsActivate: function() {
        var that = this;
        var isTouch = $('html').hasClass('is-touch') || $('html').hasClass('is-tablet');

        passport.api
            .request(
                'appPwdActivate',
                {
                    track_id: that.track_id,
                    csrf_token: that.csrf
                },
                {
                    cache: false,
                    abortPrevious: true
                }
            )
            .done(function(response) {
                if (response.body && response.body.status === 'ok') {
                    if (isTouch) {
                        passport.block('application-pwd-popup').refreshPage();
                    } else {
                        that.closePromo();
                        passport.block('application-pwd-popup').open();
                        $('.create-appPassword-wrapper')
                            .removeClass('g-hidden app-passwords-off')
                            .addClass('app-passwords-on');
                        $('.access-isle_type_tokens').removeClass('g-hidden');
                        $('.js-appwd-promo_enable').remove();
                    }
                }
                if (response.status === 'error' && Array.isArray(response.errors)) {
                    if (response.errors[0] === 'action.not_required') {
                        passport.block('application-pwd-popup').open();
                    }
                    that.processErrors(response.errors[0]);
                }
            });
    },

    appPasswordsDeactivate: function() {
        var that = this;

        passport.api
            .request(
                'appPwdDeactivate',
                {
                    track_id: that.track_id,
                    csrf_token: that.csrf
                },
                {
                    cache: false,
                    abortPrevious: true
                }
            )
            .done(function(response) {
                if (response.body && response.body.status === 'ok') {
                    location.href = location.protocol + '//' + location.host + '/profile/access';
                }
                if (response.status === 'error' && Array.isArray(response.errors)) {
                    that.processErrors(response.errors[0]);
                }
            });
    },

    processErrors: function(error) {
        if (error === 'account.without_password') {
            location.href =
                location.protocol +
                '//' +
                location.host +
                '/passport?mode=postregistration&origin=passport_profile&retpath=' +
                location.protocol +
                '//' +
                location.host +
                '/profile/access';
        }
        if (error === 'password.required') {
            this.redirectToEnterPass();
        }
    },

    redirectToEnterPass: function() {
        location.href =
            location.protocol +
            '//' +
            location.host +
            '/auth/verify?retpath=' +
            location.protocol +
            '//' +
            location.host +
            '/profile/access';
    },

    openPromo: function() {
        $('.js-appwd-promo')
            .first()
            .removeClass('appwd-promo-collapsed');

        if (passport.isTouch) {
            $('html, body').animate(
                {
                    scrollTop: $('.js-anchor').offset().top
                },
                'slow'
            );
        }
    },

    closePromo: function() {
        $('.js-appwd-promo').addClass('appwd-promo-collapsed');
    }
});

passport.block('application-pwd-popup', {
    events: {
        'click .application-pwd-popup-item': 'selectItem',
        'click .js-application-pwd-popup-done-button': 'refreshPage',
        'click .js-application-pwd-popup-custom-back': 'hideCustomField',
        'click .js-application-pwd-popup-add-custom': 'addCustomData',
        'click .js-pwd-popup-close': 'close',
        'click .post-active': 'showCheckedItem'
    },

    data: {},

    init: function() {
        this.data.csrf = $('.js-application-pwd-popup-csrf').val();
        this.paranja = $('.js-application-pwd-popup-paranja');
        this.spinner = $('.get-alias_spinner');
        this.inProgress = false;
        this.resetState = this.$('.application-pwd-popup-list').clone(true);

        if (window.location.hash === '#open_popup') {
            window.location.hash = '';
            this.open();
        }

        if (!ZeroClipboard) {
            return;
        }

        var $copyFeedback = this.$('.js-application-pwd-popup-alias-copied');

        ZeroClipboard.config({
            swfPath: passport.staticPath + 'js/ZeroClipboard.swf'
        });

        var $clippy = this.$('.js-application-pwd-popup-alias-clippy');
        var clipboard = new ZeroClipboard($clippy);

        clipboard.on('copy', function() {
            var hiddenClass = 'application-pwd-popup-alias-copied-hidden';

            $copyFeedback.removeClass(hiddenClass);
            setTimeout(function() {
                $copyFeedback.addClass(hiddenClass);
            }, 2000);
        });

        var clippyHiddenClass = 'application-pwd-popup-alias-clippy-hidden';

        clipboard.on('error', function() {
            $clippy.addClass(clippyHiddenClass);
        });
        clipboard.on('ready', function() {
            $clippy.removeClass(clippyHiddenClass);
        });
    },

    open: function() {
        this.paranja.removeClass('g-hidden');
        this.$el.addClass('show-popup');
        this.spinner.removeClass('g-hidden');
    },

    close: function() {
        this.paranja.addClass('g-hidden');
        this.$el.removeClass('show-popup');
        this.resetPopup();
    },

    resetPopup: function() {
        this.$('.application-pwd-popup-list').replaceWith(this.resetState);
        this.init();
    },

    updateTitle: function(text, elemClass) {
        var activeBlock = $('.application-pwd-popup-wrapper.active');
        var titleBlock = activeBlock.first().find('.application-pwd-popup-show-selected');
        var elClass;

        titleBlock.removeClass();
        titleBlock.addClass('application-pwd-popup-show-selected');
        titleBlock.text(text);

        if (elemClass) {
            elClass = 'popup-selected-' + elemClass;
            titleBlock.addClass(elClass);
        }
    },

    updateBlock: function() {
        var currentBlock = $('.application-pwd-popup-wrapper.active');
        var nextBlock = currentBlock.first().next();
        var self = this;

        currentBlock.removeClass('active').addClass('post-active');

        nextBlock.removeClass('post-active').addClass('active');

        setTimeout(function() {
            self.inProgress = false;
        }, 1000); // ugly hack
    },

    selectItem: function(event) {
        if (this.inProgress) {
            return false;
        }

        this.inProgress = true;
        var $selected = $(event.currentTarget);
        var $selectedClass = $selected.attr('class');
        var cssClass = '';

        $selectedClass = $selectedClass.split(' ');
        cssClass = $selectedClass.pop();

        if (cssClass === 'another') {
            this.showCustomField($selected);
        } else {
            this.updateTitle($selected.text(), cssClass);
            this.updateBlock();
            this.processSelectedValue($selected.data());
        }
    },

    showCustomField: function(elem) {
        elem.parent().addClass('g-hidden');
        $('.js-application-pwd-popup-custom')
            .removeClass('g-hidden')
            .find('input')
            .focus();
    },

    hideCustomField: function() {
        $('.js-application-pwd-popup-custom').addClass('g-hidden');
        $('.application-pwd-popup-items').removeClass('g-hidden');
        $('.application-pwd-popup-show-selected').removeClass('popup-selected-custom');
        this.inProgress = false;
    },

    processSelectedValue: function(obj) {
        $.extend(this.data, obj);
        if ('app' in this.data && 'os' in this.data) {
            this.data.name = this.data['app'] + ' ' + this.data['os'];

            if (this.data.name.length > 100) {
                this.data.name = this.data.name.slice(0, 100);
            }
            delete this.data['app'];
            delete this.data['os'];
            this.getAppPassword(this.data);
        }
    },

    addCustomData: function(event) {
        var type = $(event.currentTarget).data('type');
        var parent = $('.js-block_name_application-pwd-popup .active');
        var customValue = parent
            .find('input')
            .val()
            .trim();
        var obj = {};
        var error = parent.find('.p-control__error');

        error.addClass('g-hidden');
        if (customValue === '') {
            error.removeClass('g-hidden');
            return;
        }
        obj[type] = customValue;
        this.updateTitle(customValue, 'custom');
        this.updateBlock();
        this.processSelectedValue(obj);
    },

    getAppPassword: function(data) {
        var that = this;

        passport.api.request('access/token/new', data).done(function(response) {
            var errors =
                response &&
                response.status &&
                response.status === 'error' &&
                Array.isArray(response.errors) &&
                response.errors;
            var a = document.createElement('a');

            a.href = window.location.href;
            a.search = '?retpath=' + encodeURIComponent(window.location.href);
            if (errors) {
                if (errors.indexOf('token.limit_exceeded') > -1) {
                    that.spinner.addClass('g-hidden');
                    $('.application-pwd-popup-alias').addClass('g-hidden');
                    $('.create-password__error').removeClass('g-hidden');
                    return;
                }

                if (errors.indexOf('sslsession.required') > -1) {
                    a.pathname = '/auth/secure';
                } else if (errors.indexOf('password.required') > -1) {
                    a.pathname = '/auth/verify';
                } else if (errors.indexOf('session.required') > -1) {
                    a.pathname = '/auth';
                }
                window.location.href = a.href;
            } else {
                that.renderPassword(response.alias);
            }
        });
    },

    renderPassword: function(password) {
        var $pwdField = $('.application-pwd-popup-alias-text');

        $('.application-pwd-password').removeClass('g-hidden');
        $('.js-application-pwd-popup-alias-clippy').attr('data-clipboard-text', password);
        this.spinner.addClass('g-hidden');
        $pwdField.text(password);
        $('.application-pwd-popup-wrapper').removeClass('post-active');
    },

    showCheckedItem: function(event) {
        var item = $(event.currentTarget);

        item.removeClass('post-active').addClass('active');
        item.next().removeClass('active');
    },

    refreshPage: function() {
        window.location.reload();
    }
});

function checkAge(callback, hash) {
    passport.api
        .request('access/pva', {
            csrf: $('.js-application-pwd-popup-csrf').val()
        })
        .done(function(result) {
            if (parseInt(result.age, 10) < 27 * 60) {
                return callback();
            } else {
                var a = document.createElement('a');
                var location = window.location;

                location.hash = hash;
                a.href = window.location.href;
                a.pathname = '/auth/verify';
                a.search = '?retpath=' + encodeURIComponent(location);
                window.location.href = a.href;
            }
        });
}

$(function() {
    var toggler = passport.block('appPwd-toggler');

    $('.js-appwd-promo-button').on('click', function() {
        checkAge(function() {
            toggler.appPasswordsActivate();
        }, 'open_promo');
    });

    $('.js-appwd-promo_disable-button').on('click', function() {
        checkAge(function() {
            toggler.appPasswordsDeactivate();
        }, 'open_promo');
    });

    $('.js-open-create-popup').on('click', function() {
        checkAge(function() {
            passport.block('application-pwd-popup').open();
        }, 'open_popup');
    });

    $('.js-appPassword-create-scope').on('change', function() {
        var $self = $(this);

        checkAge(function() {
            $self.focus();
        }, 'create');
    });
});
