import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {NoJS} from '@components/NoJS';
import Header from '@components/Header/Header.jsx';
import {Domik} from '@blocks/morda/components/domik/domik.jsx';
import Footer from '@components/Footer/Footer.jsx';
import WrappedDeleteContainer from '@blocks/delete/deleteContainer.jsx';

class App extends Component {
    render() {
        const {common: {isAppMode} = {}} = this.props;

        return (
            <div className='layout-inner utilityfocus'>
                <NoJS />
                {!isAppMode && <Header />}
                <div className='grid'>
                    <WrappedDeleteContainer />
                </div>
                <Domik />
                {!isAppMode && <Footer />}
            </div>
        );
    }
}

App.propTypes = {
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    header: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired
};

export default connect((state) => state)(App);
