import {renderClient} from '@components/Layout/client';
import configureStore from './configureStore';
import App from './app.jsx';

document.addEventListener('DOMContentLoaded', () => {
    const reduxStore = window.__REDUX_STORE__;
    const {deleteAccount} = reduxStore;
    const dataForMetric = [
        `блокирующие сиды: ${translateDataForMetrics(deleteAccount.hasBlockingSids)}`,
        `cпособ подтверждения удаления: ${translateDataForMetrics(deleteAccount.confirmation.method)}`
    ];

    return renderClient({
        App,
        configureStore,
        metricsData: ['показ страницы', ...dataForMetric]
    });
});

function translateDataForMetrics(data) {
    const words = {
        true: 'да',
        false: 'нет',
        question: 'контрольный вопрос',
        email: 'адрес электронной почты',
        phone: 'телефон'
    };

    return words[data];
}
