// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

/* jshint undef: false */
/* globals ymaps */

$(function() {
    passport.block('journal-list', 'block', {
        events: {
            'click .js-show_more-btn': 'showMoreItems',
            'click .js-show-hidden': 'showHidden'
        },

        tld: 'ru',
        listData: null,
        listDataToRender: [],
        mapData: null,
        period: '',
        yu: '',
        is2faOn: false,
        NUMBER_OF_EVENTS_SHOWED: 5,
        journalType: '',
        nextPage: null,

        getEventsList: function(handler, period) {
            var self = this;
            var csrf = passport.sk;
            var data = {
                csrf_token: csrf,
                hours_limit: period
            };

            this.period = period;

            passport.api
                .request(handler, data)
                .done(function(response) {
                    self.listData = response.journal;
                    self.nextPage = response.nextPage;
                    self.processDataToChunks(response.journal);

                    if (response.map) {
                        self.mapData = response.map;

                        $('.map-wrapper').removeClass('g-hidden');
                        if (self.journalType === 'actions') {
                            passport.block('journal-map').renderMap(self.mapData, 'actions');
                        } else {
                            passport.block('journal-map').renderMap(self.mapData, 'auth');
                        }
                    } else {
                        $('.map-wrapper').addClass('g-hidden');
                    }
                })
                .fail(function() {
                    location.href = location.protocol + '//' + location.host + location.pathname;
                });
        },

        getMoreEventsList: function(handler, period) {
            var self = this;
            var csrf = passport.sk;
            var data = {
                csrf_token: csrf,
                hours_limit: period
            };

            if (self.journalType === 'actions') {
                data.from_timestamp = self.nextPage;
            } else {
                data.from_auth_row = self.nextPage;
            }

            this.period = period;

            passport.api
                .request(handler, data)
                .done(function(response) {
                    self.listData = response.journal;
                    self.nextPage = response.nextPage;

                    self.showMoreItems();

                    if (response.map) {
                        if (self.mapData) {
                            self.mapData.points = self.mapData.points.concat(response.map.points);
                            self.mapData.pointInfo = self.mapData.pointInfo.concat(response.map.pointInfo);
                        } else {
                            self.mapData = response.map;
                        }

                        $('.map-wrapper').removeClass('g-hidden');
                        if (self.journalType === 'actions') {
                            passport.block('journal-map').renderMap(self.mapData, 'actions');
                        } else {
                            passport.block('journal-map').renderMap(self.mapData, 'auth');
                        }
                    } else {
                        $('.map-wrapper').addClass('g-hidden');
                    }
                })
                .fail(function() {
                    location.href = location.protocol + '//' + location.host + location.pathname;
                });
        },

        processDataToChunks: function(dataArray) {
            var length;
            var dataToRender = dataArray;

            if (dataArray && dataArray.length) {
                length = dataArray.length;
                dataToRender =
                    length > this.NUMBER_OF_EVENTS_SHOWED
                        ? dataArray.splice(0, this.NUMBER_OF_EVENTS_SHOWED)
                        : dataArray.splice(0, length);
            }

            this.listDataToRender = dataToRender;
            this.renderEvents(dataToRender);
        },

        showMoreItems: function() {
            if (!this.listData) {
                return;
            }

            if (!this.listData.length && this.nextPage) {
                var historyType = $('.period-toggler').data('type');

                if (historyType === 'actions') {
                    this.getMoreEventsList('profile/actions', this.period);
                } else if (historyType === 'auth') {
                    this.getMoreEventsList('profile/journal', this.period);
                }

                return;
            }

            var newItems =
                this.listData.length > this.NUMBER_OF_EVENTS_SHOWED
                    ? this.listData.splice(0, this.NUMBER_OF_EVENTS_SHOWED + 1)
                    : this.listData.splice(0, this.listData.length);

            this.listDataToRender = this.listDataToRender.concat(newItems);

            this.renderEvents(this.listDataToRender);
        },

        renderEvents: function(items) {
            var template = 'journal-auth';
            var itemsToRender = items;

            if (this.journalType === 'actions') {
                template = 'journal-actions';
            } else {
                itemsToRender = this.groupByDates(items);
            }

            var objToRender = {
                listData: {
                    itemsToRender: itemsToRender
                },
                period: this.period,
                is2FAOn: this.is2faOn,
                domain: this.tld,
                next: false
            };

            if ((this.listData && this.listData.length > 0) || this.nextPage) {
                objToRender.next = true;
            }

            if (this.yu) {
                objToRender.yu = this.yu;
            }
            $('.journal-events-wrapper').html(yr.run('profile.journal', objToRender, template));
            passport.block('wasnt-me').construct($('*[data-block="wasnt-me"]'));
        },

        showHidden: function(event) {
            $(event.currentTarget)
                .next('.extended-info')
                .toggleClass('g-hidden');
        },

        groupByDates: function(data) {
            var current;
            var currentDate;
            var dates = [];
            var events = [];

            if (data && data.length) {
                current = data[0].timestamp;
                currentDate = data[0].titleTime;
            } else {
                return [];
            }

            for (var i = 0; i < data.length; i++) {
                var loopItem = data[i];

                if (current !== loopItem.timestamp) {
                    // save remembered events in new group
                    var newGroup = {
                        data: currentDate,
                        items: events
                    };

                    dates.push(newGroup);

                    currentDate = loopItem.titleTime;
                    current = loopItem.timestamp;
                    events = [];
                }
                // add event to group
                events.push(loopItem);
            }

            if (events.length) {
                var newDateGroup = {
                    data: currentDate,
                    items: events
                };

                dates.push(newDateGroup);
            }

            return dates;
        },

        init: function() {
            var dataBlock = $('#events-data');
            var listData = dataBlock.data('items').data;

            this.listData = dataBlock.data('items').data;

            if (listData && listData.length) {
                this.listDataToRender =
                    listData.length > this.NUMBER_OF_EVENTS_SHOWED
                        ? listData.splice(0, this.NUMBER_OF_EVENTS_SHOWED + 1)
                        : listData.splice(0, listData.length);
            }

            this.journalType = dataBlock.data('type');
            this.yu = dataBlock.data('yu');
            this.is2faOn = dataBlock.data('twofa');
            this.nextPage = dataBlock.data('nextPage');
            this.period = dataBlock.data('period');
            this.tld = $('body').data('tld');
        }
    });

    passport.block('journal-map', 'block', {
        mapActive: false,
        mapData: null,

        entersDict: {
            one: i18n('%profile.journal.enter_one'),
            some: i18n('%profile.journal.enter_some'),
            many: i18n('%profile.journal.enter_many')
        },

        actionsDict: {
            one: i18n('%profile.journal.action_one'),
            some: i18n('%profile.journal.action_some'),
            many: i18n('%profile.journal.action_many')
        },

        renderMap: function(data, mapType) {
            if (data.points && data.points.length > 0) {
                var self = this;
                var mapCenter = data.points[0] || null;
                var map = new ymaps.Map('journal-map', {
                    center: mapCenter,
                    //zoom: data.pointInfo[0].zoom || 10,
                    zoom: data.pointInfo[0].zoom || 8,
                    autoFitToViewport: 'always',
                    controls: ['zoomControl', 'fullscreenControl']
                });
                var placemarks = [];
                var points = data.points;
                var pointInfo = data.pointInfo;

                var locStr = i18n('%profile.journal.map-enters').replace('%s', '{{ geoObject.length }}');
                // Создаем собственный макет с информацией о выбранном геообъекте.
                var customBalloonContentLayout = ymaps.templateLayoutFactory.createClass(
                    [
                        '<ul class=map-objects-list>',
                        // Выводим в цикле список всех геообъектов.
                        '{% for geoObject in state.geoObjects %}',
                        // eslint-disable-next-line max-len
                        '<li><span class="map-objects-list-item">{{ geoObject.balloonContentHeader|raw }}</span> <span class="map-objects-list-item">{{ geoObject.balloonContentBody|raw }}</span></li>',
                        '{% endfor %}',
                        '</ul>',
                        '{% for geoObject in state.geoObjects %}',
                        '{% if geoObject.length %}',
                        '<p>' + locStr + '</p>',
                        '{% endif %}',
                        '{% endfor %}'
                    ].join('')
                );

                var clusterer = new ymaps.Clusterer({
                    clusterDisableClickZoom: true,
                    clusterOpenBalloonOnClick: true,
                    clusterBalloonPanelMaxMapArea: 0,
                    clusterBalloonMaxHeight: 200,
                    clusterBalloonMaxWidth: 220,
                    // Устанавливаем собственный макет контента балуна.
                    clusterBalloonContentLayout: customBalloonContentLayout
                });

                clusterer.options.set({
                    gridSize: 1024
                });

                if (this.mapActive) {
                    map.destroy();
                    $('#journal-map').empty();
                    map = new ymaps.Map('journal-map', {
                        center: mapCenter,
                        zoom: data.pointInfo[0].zoom || 8,
                        maxZoom: 10,
                        minZoom: 10,
                        controls: ['zoomControl', 'fullscreenControl']
                    });
                }

                // Заполняем кластер геообъектами
                for (var i = 0, l = points.length; i < l; i++) {
                    var pointsObj = {
                        balloonContentBody: this.processPointInfoData(pointInfo[i])
                    };

                    if (mapType === 'auth') {
                        pointsObj.balloonContentHeader =
                            '<span class="map-objects-enters">' +
                            pointInfo[i].count +
                            ' ' +
                            this.makePluralText(pointInfo[i].count, this.entersDict) +
                            '</span>';
                        pointsObj.count = pointInfo[i].count;
                    }
                    // Устаналиваем данные, которые будут отображаться в балуне.
                    var placemark = new ymaps.Placemark(points[i], pointsObj);

                    placemarks.push(placemark);
                }

                clusterer.add(placemarks);

                clusterer.createCluster = function() {
                    var NUM_OF_ITEMS = 6;
                    var clusterPlacemark = ymaps.Clusterer.prototype.createCluster.apply(this, arguments);
                    // Массив геообъектов, которые находятся в данном кластере
                    var clusterObjects = clusterPlacemark.properties.get('geoObjects');
                    // число объектов в кластере, которые "остались" после того, как мы забрали NUM_OF_ITEMS,
                    // чтобы подробно показать их в балуне
                    var restMapPoints = clusterObjects.length - NUM_OF_ITEMS;
                    var lastEvents = clusterObjects.slice(0, NUM_OF_ITEMS).map(function(geoObject) {
                        return geoObject.properties.getAll();
                    });

                    lastEvents.sort(function(obj1, obj2) {
                        return obj2.count - obj1.count;
                    });

                    clusterPlacemark.state.set(
                        'geoObjects',
                        lastEvents.map(function(item, index) {
                            if (item.length) {
                                item.length = '';
                            }
                            if (restMapPoints > 0 && index === 0) {
                                if (mapType === 'auth') {
                                    item.length =
                                        restMapPoints + ' ' + self.makePluralText(restMapPoints, self.entersDict);
                                }

                                if (mapType === 'actions') {
                                    item.length =
                                        restMapPoints + ' ' + self.makePluralText(restMapPoints, self.actionsDict);
                                }
                            }
                            return item;
                        })
                    );
                    return clusterPlacemark;
                };

                map.geoObjects.add(clusterer);

                const bounds = clusterer.getBounds();

                // Выставляет центр карты в центр области показа меток
                // На 1 метку создается 2 массива с одинаковыми координатами (логика внутри ymaps)
                // Поэтому смотрим на количество > 2
                // Когда метка всего одна, этот метод выставляет максимальный зум
                // Когда меток будет больше, будет изменение зума так, что они все поместятся на карте
                if (bounds.length > 2) {
                    map.setBounds(bounds, {
                        checkZoomRange: true
                    });
                }

                map.container.fitToViewport();
                this.mapActive = true;
            } else {
                return;
            }
        },

        makePluralText: function(number, dictionary) {
            return i18n['tanker']['dynamic']['plural']({
                count: number,
                one: dictionary['one'],
                some: dictionary['some'],
                many: dictionary['many']
            });
        },

        processPointInfoData: function(data) {
            var string = data.actionName || data.authType;
            var processDeviceName = function(s) {
                // encode and remove "+" from deviceName
                var elem = document.createElement('div');
                var formatted = s.replace(/\+/g, ' ');

                elem.innerText = elem.textContent = formatted;
                formatted = elem.innerHTML;
                return formatted;
            };

            if (data.browser) {
                string += '<br><span class="map-objects-grey">' + data.browser.name + ' ' + data.browser.version;
            }

            if (data.os) {
                if (data.os.name) {
                    string += ' - ' + data.os.name;
                } else {
                    string += ',';
                }
                if (data.os.version) {
                    string += ' ' + data.os.version;
                }
            }

            if (data.deviceName) {
                string += '<br> <span class="map-objects-grey">' + processDeviceName(data.deviceName) + '</span>';
            }

            string += '</span>';
            return string;
        },

        init: function() {
            var historyType = $('.period-toggler').data('type');

            ymaps.ready(function() {
                this.mapData = $('#map-data').data('map');

                passport.block('journal-list').mapData = this.mapData;

                if (historyType === 'auth') {
                    passport.block('journal-map').renderMap(this.mapData, 'auth');
                } else {
                    passport.block('journal-map').renderMap(this.mapData, 'actions');
                }
            }); // map button enables after the ymaps.ready event is fired
        }
    });

    passport.block('period-toggler', 'block', {
        events: {
            'click .js-button': 'togglePeriod'
        },

        togglePeriod: function(event) {
            var elemId = '#' + $(event.currentTarget).attr('for');
            var period = $(elemId).val();
            var url = location.protocol + '//' + location.host + location.pathname + '?period=' + period;
            var historyType = $('.period-toggler').data('type');

            history.replaceState(null, null, url);
            $('.js-no-data').addClass('g-hidden');

            if (historyType === 'actions') {
                passport.block('journal-list').getEventsList('profile/actions', period);
            } else if (historyType === 'auth') {
                passport.block('journal-list').getEventsList('profile/journal', period);
            }
        }
    });

    passport.block('wasnt-me', 'block', {
        events: {
            'click .js-not-me': 'showNotMeBlock',
            'click .js-is-ok': 'hideNotMeBlock'
        },

        showNotMeBlock: function(event) {
            var parent = $(event.currentTarget).parents('.journal-block');

            $('.journal-block').removeClass('active-block');
            parent.addClass('active-block');
        },

        hideNotMeBlock: function() {
            $('.journal-block').removeClass('active-block');
        }
    });

    var isTouch = $('html').hasClass('is-touch');

    function setMapWidth() {
        var MAP_PADDING = 60;
        var viewportWidth = document.documentElement.clientWidth;
        var mapWidth = viewportWidth - MAP_PADDING;

        document.getElementById('journal-map').style.width = mapWidth + 'px';
    }
    if (isTouch) {
        setMapWidth();
        window.addEventListener('orientationchange', function() {
            setMapWidth();
            passport.block('journal-map').init();
        });
    }

    passport.init();
    nb.init();
});
