import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {Route, Switch, withRouter} from 'react-router-dom';

import {Footer} from '@components/Footer/New.js';
import {NoJS} from '@components/NoJS';
import {Header} from '@blocks/morda/components/header/header.jsx';
import MordaIntranet from '@blocks/morda_intranet/morda_intranet.jsx';
import PasswordPage from '@blocks/morda/new/forms/password/page.jsx';

import './app.styl';
import './header.styl';
import '@components/Footer/New.styl';

export const App = ({tld, env, help, isPhone, language, location, settings, footer}) => (
    <div
        className={classnames('layout-inner', {
            'layout-inner_desktop': !isPhone
        })}
    >
        <NoJS />
        <Header />
        <div className='profile'>
            <div className='profile__wrapper'>
                <div className='profile__inner'>
                    <Switch location={location}>
                        <Route exact={true} path='/profile'>
                            <MordaIntranet />
                        </Route>
                        <Route exact={true} path='/profile/password'>
                            <div className='profile__page'>
                                <PasswordPage />
                            </div>
                        </Route>
                    </Switch>
                    <div className='profile__footer'>
                        <Footer
                            env={env}
                            help={help}
                            tld={tld}
                            language={language}
                            settings={settings}
                            location={location.pathname}
                            langlist={footer && footer.langlist}
                        />
                    </div>
                </div>
            </div>
        </div>
    </div>
);

App.defaultProps = {
    ua: {}
};

App.propTypes = {
    env: PropTypes.object,
    help: PropTypes.object,
    isPhone: PropTypes.bool,
    tld: PropTypes.string.isRequired,
    location: PropTypes.shape({
        pathname: PropTypes.string.isRequired
    }).isRequired,
    language: PropTypes.string.isRequired,
    settings: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired
};

export default withRouter(
    connect(
        ({settings, footer}) => {
            const {tld, env, help, isPhone, language} = settings;

            return {
                tld,
                env,
                help,
                isPhone,
                language,
                footer,
                settings
            };
        },
        undefined,
        undefined,
        {
            pure: false
        }
    )(App)
);
