import {compose, createStore, combineReducers, applyMiddleware} from 'redux';
import thunkMiddleware from 'redux-thunk';
import {connectRouter, routerMiddleware} from 'connected-react-router';
import reducers from '../../../blocks/react-blocks/morda_intranet/reducers';

const devTools =
    typeof window === 'object' &&
    typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.__REDUX_DEVTOOLS_EXTENSION__()
        : (f) => f;

/* prettier-ignore */
export default (initialState, history) =>
    createStore(
        combineReducers({...reducers, router: connectRouter(history)}),
        initialState,
        compose(
            applyMiddleware(thunkMiddleware, routerMiddleware(history)),
            devTools
        )
    );
