import createMemoryHistory from 'history/createMemoryHistory';
import {renderServer} from '@components/Layout/server';
import configureStore from './configureStore';
import App from './app.jsx';

export const renderPage = (res) => {
    const {settings = {}} = res.locals.store || {};
    const {location} = settings;
    const history = createMemoryHistory({initialEntries: [location || '/profile']});

    return renderServer(res, {
        title: i18n('Frontend.passport.title'),
        App,
        history,
        configureStore,
        withRouter: true,
        withProvider: true
    });
};
