import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import reducers from '../../../blocks/react-blocks/passport.reducers';
import {connectRouter, routerMiddleware} from 'connected-react-router';

const getRootReducer = (history) =>
    combineReducers(
        Object.assign({}, reducers, {
            router: connectRouter(history)
        })
    );

export default function(initialState, history) {
    const devTools =
        typeof window === 'object' &&
        typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
        process.env.NODE_ENV !== 'production'
            ? window.__REDUX_DEVTOOLS_EXTENSION__()
            : (f) => f;

    return createStore(
        getRootReducer(history),
        initialState,
        compose(applyMiddleware(thunkMiddleware, routerMiddleware(history)), devTools)
    );
}
