import Dashboard from '@blocks/morda/dashboard/dashboard.jsx';
import AddressesControl from '@blocks/morda/addresses/components/addresses_control/index.jsx';
import {PersonalInfoEditForm} from '@blocks/morda/personal_info/personal_info_form.jsx';
import {PublicId} from '@screens/PublicId';
import SocialForm from '@blocks/morda/social_info/modal/modal.jsx';
import KvKo from '@blocks/morda/security/user_question/modal.jsx';
import EmailsListPage from '@blocks/morda/emails/emails_list/page.jsx';
import AddEmailPage from '@blocks/morda/emails/add_email/page.jsx';
import CardsControl from '@blocks/morda/cards/cards_control.jsx';
import {AvatarInfo} from '@blocks/morda/avatar/components/avatar.jsx';
import {AppPasswordsList} from '@blocks/morda/app_passwords/app_passwords_list.jsx';
import {CreateAppPasswordBlock} from '@blocks/morda/create_app_passwords/create_app_passwords_block.jsx';
import {DevicesList} from '@blocks/morda/devices/devices_list.jsx';
import DisplayNameEditForm from '@blocks/morda/personal_info/display_name_edit_form.jsx';
import PasswordPage from '@blocks/morda/new/forms/password/page.jsx';
import MordaNew from '@blocks/morda/new/morda.jsx';
import withReturnToService from '@blocks/hocs/withReturnToService';
import withWrapper from '@blocks/hocs/withWrapper';
import AliceModal from '@blocks/morda/new/other_settings_block/alice/modal.jsx';
import {Family, FamilyLimits} from '@blocks/morda/new/family';
import {Support} from '@blocks/morda/new/support';
// eslint-disable-next-line max-len
import {EnterWithoutPasswordPage} from '@blocks/morda/new/auth_block/without_password/without_password.jsx';
import {Subs} from '@blocks/Subs/Subs';
import {Bonus} from '@blocks/morda/bonus';
import {Passwords} from '@blocks/morda/passwords';
import {Documents} from '@blocks/morda/documents';

const getRoutes = ({isShowNoPasswordSettingsExp, isSupportEnabled}) => {
    const routes = [
        {
            path: '/profile',
            component: MordaNew
        },
        {
            path: '/profile/my',
            component: Dashboard
        },
        {
            path: '/profile/favorites',
            component: Dashboard
        },
        {
            path: '/profile/services',
            component: Dashboard
        },
        {
            path: '/profile/personal-info',
            component: withReturnToService(PersonalInfoEditForm, 'p-sec')
        },
        {
            path: '/profile/change-hint',
            component: withReturnToService(KvKo, 'p-sec')
        },
        {
            path: '/profile/social',
            component: withReturnToService(SocialForm, 'p-sec')
        },
        {
            path: '/profile/social/:profileId',
            component: withReturnToService(SocialForm, 'p-sec')
        },
        {
            path: '/profile/address',
            component: withReturnToService(AddressesControl, 'p-sec')
        },
        {
            path: '/profile/emails',
            component: withReturnToService(EmailsListPage, 'p-sec')
        },
        {
            path: '/profile/emails/list',
            component: withReturnToService(EmailsListPage, 'p-sec')
        },
        {
            path: '/profile/emails/add',
            component: withReturnToService(AddEmailPage, 'p-sec')
        },
        {
            path: '/profile/cards',
            component: withReturnToService(CardsControl, 'p-sec')
        },
        {
            path: '/profile/avatars',
            component: withReturnToService(AvatarInfo, 'p-sec')
        },
        {
            path: '/profile/generate-apppassword',
            component: withReturnToService(CreateAppPasswordBlock, 'p-sec')
        },
        {
            path: '/profile/apppasswords-list',
            component: withReturnToService(AppPasswordsList, 'p-sec')
        },
        {
            path: '/profile/devices',
            component: withReturnToService(DevicesList, 'p-sec')
        },
        {
            path: '/profile/display-name',
            component: withReturnToService(DisplayNameEditForm, 'p-sec')
        },
        {
            path: '/profile/password',
            component: withWrapper(PasswordPage, 'p-sec p-sec_visible')
        },
        {
            path: '/profile/alice-settings',
            component: withReturnToService(AliceModal, 'p-sec')
        },
        {
            path: '/profile/auth-settings',
            component: isShowNoPasswordSettingsExp ? withReturnToService(EnterWithoutPasswordPage, 'p-sec') : MordaNew
        },
        {
            path: '/profile/family/invite/:inviteId',
            component: Family
        },
        {
            path: '/profile/family(/invite|/after3ds|/pay-cards|/kids)?',
            component: Family
        },
        {
            path: '/profile/family/welcome',
            component: Family
        },
        {
            path: '/profile/family/limits',
            component: FamilyLimits
        },
        {
            path: '/profile/subs',
            component: Subs
        },
        {
            path: '/profile/publicid',
            component: PublicId
        },
        {
            path: '/profile/bonus',
            component: Bonus
        },
        {
            path: '/profile/passwords',
            component: Passwords
        },
        {
            path: '/profile/documents',
            component: Documents
        },
        {
            // Отдельный путь к док-ам для ПП для открытия по шорткату.
            path: '/profile/documents/pp',
            component: Documents
        }
    ];

    if (isSupportEnabled) {
        routes.push({
            path: '/support',
            component: Support
        });

        routes.push({
            path: '/support/:guid/:timestamp?',
            component: Support
        });
    }

    return routes;
};

export default getRoutes;
