// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/auth.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/access-tokens/access-tokens.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

$(function() {
    var isTouch = $('html').hasClass('is-touch') || $('html').hasClass('is-tablet');
    var blockSubmit = passport.block('submit');
    var onInvalid = blockSubmit.onInvalid;
    var fieldsMetrics = {
        current_password: 'Заполнение текущего пароля',
        password: 'Заполнение нового пароля',
        password_confirm: 'Заполнение повторного пароля'
    };

    function sendMetrics(value) {
        passport.Metrika.count(['Смена пароля', value]);
    }

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    sendMetrics('Открытие');

    blockSubmit.onInvalid = function() {
        sendMetrics('Показ ошибок');
        return onInvalid.apply(this, arguments);
    };

    $('.js-edit-logout').one('click', function() {
        sendMetrics('Нажатие на "изменить доступы"');
    });

    for (var field in fieldsMetrics) {
        if (fieldsMetrics.hasOwnProperty(field)) {
            (function(key) {
                $('#' + key).one('keydown', function() {
                    sendMetrics(fieldsMetrics[key]);
                });
            })(field);
        }
    }

    if (!isTouch) {
        $('input:visible')
            .first()
            .focus();
    }

    $('.js-show-apps').click(function() {
        passport.block('tokens-popup').openPopup();
    });
});
