// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

$(function() {
    var headerMetrics = ['Страница безопасности'];
    var headerGoal = ['security_page'];
    var metricEvent = 'mousedown';

    if ('ontouchstart' in window) {
        metricEvent = 'touchstart';
    }

    function sendMetric(params) {
        if (headerMetrics) {
            passport.Metrika.count(headerMetrics.concat(params));
        }
    }

    function metricsReachGoal(params) {
        if (headerGoal) {
            passport.Metrika.reachGoal(headerGoal.concat(params).join('_'));
        }
    }

    passport.block('security-settings', 'block', {
        tabsPassed: false,
        phoneConfirmed: false,

        events: {
            'click .js-not-me-btn': 'showInfo',
            'click .js-is-ok': 'hideInfo',
            'click .js-next-tab': 'openNextTab',
            'click .js-cancel-phone': 'resetPhoneInput',
            'click .js-show-emails': 'showEmails',
            'click .js-finish': 'showFinishTab',
            'click .passed-tab': 'openPassedTab',
            'codeSent.phone-confirm': 'showCancelBtn',
            'phoneConfirmed.phone-confirm': 'updateAccountView'
        },

        showFinishTab: function() {
            $('.security-settings-finish').removeClass('g-hidden');
            $('.history-tab')
                .removeClass('active-tab')
                .addClass('passed-tab');
            $('.security-settings-journal-event').removeClass('active');
            this.tabsPassed = true;
        },

        showInfo: function(event) {
            var parent = $(event.currentTarget).parents('.security-settings-journal-event');

            this.journalEvent.removeClass('active');
            parent.addClass('active');
        },

        hideInfo: function() {
            this.journalEvent.removeClass('active');
        },

        openNextTab: function(event) {
            var button = $(event.currentTarget);
            var nextTab = button.data('next');
            var currentTab = button.data('current');
            var phoneId = button.data('phone');
            var openTab = '.' + nextTab + '-tab';
            var passedTab = '.' + currentTab + '-tab';
            var metrics = {
                phone: 'Номер телефона',
                account: 'Пароль',
                email: 'Запасная почта',
                history: 'История входов'
            };

            if (!this.tabsPassed) {
                if (nextTab === 'history' && !$('.history-tab').length) {
                    $(passedTab).addClass('border-bottom');
                    this.showFinishTab();
                }
                $(passedTab)
                    .removeClass('active-tab')
                    .addClass('passed-tab');

                if ($(openTab).length) {
                    $(openTab).addClass('active-tab');
                    $('html, body').animate(
                        {
                            scrollTop: $(openTab).offset().top
                        },
                        'slow'
                    );
                }

                if (currentTab === 'phone' || currentTab === 'email') {
                    this.updateBlockText(currentTab);
                }

                if (currentTab === 'phone' && !this.phoneConfirmed && phoneId) {
                    this.confirmNumber(phoneId);
                }
            } else {
                $(passedTab).toggleClass('active-tab');
            }

            sendMetric([metrics[nextTab], 'Показ блока']);
            metricsReachGoal([nextTab + '-tab', 'show_block']);
        },

        updateBlockText: function(block) {
            var blockClass = '.js-settings-' + block;
            var blockElem = $(blockClass);
            var texts = blockElem.data().text;

            if (texts.title) {
                blockElem.find('.text-title').text(texts.title);
            }

            if (texts.text || texts.text === ' ') {
                blockElem.find('.security-settings-field-text').text(texts.text);
            }

            if (texts.buttonTxt) {
                blockElem.find('.button-link').text(texts.buttonTxt);
            }

            if (texts.alternateButtonTxt) {
                blockElem.find('.js-next-tab ._nb-button-content').text(texts.alternateButtonTxt);
            }
        },

        openPassedTab: function(event) {
            var passedTab = $(event.currentTarget);
            var classNames = passedTab.attr('class').split(' ');
            var metrics = {
                'phone-tab': 'Номер телефона',
                'account-tab': 'Пароль',
                'email-tab': 'Запасная почта',
                'history-tab': 'История входов'
            };

            var currentTab = ['phone-tab', 'account-tab', 'email-tab', 'history-tab'].filter(function(item) {
                return classNames.indexOf(item) > -1;
            })[0];

            if (passedTab.hasClass('active-tab')) {
                passedTab.removeClass('active-tab');
            } else {
                passedTab.addClass('active-tab');

                if (currentTab) {
                    sendMetric([metrics[currentTab], 'Показ блока']);
                    metricsReachGoal([currentTab, 'show_block']);
                }
            }
        },

        showCancelBtn: function() {
            this.cancelPhoneBinding.removeClass('g-hidden');
        },

        resetPhoneInput: function() {
            passport.block('phone-confirm').restart();
            passport.block('phone-confirm-code').stopTimer();
            passport.block('phone-confirm').getModel()._codeSent = false; // hack: PASSP-17426
            $('#phone_number').val('');
            this.cancelPhoneBinding.addClass('g-hidden');
        },

        showEmails: function() {
            $('.js-show-emails').addClass('g-hidden');
            $('.js-more-emails').removeClass('g-hidden');
        },

        updateAccountView: function() {
            this.cancelPhoneBinding.addClass('g-hidden');
            passport.api.request('getAccountData', {status: 'phone_confirmed'}).done(function(response) {
                var securityClass = 'security-' + response.securityLevel;

                $('#security-icon')
                    .removeClass()
                    .addClass(securityClass);
                $('.js-settings-phone .next-link').addClass('g-hidden');
                $('.next-action-btn')
                    .removeClass('g-hidden')
                    .find('._nb-button-content')
                    .text(i18n('%profile.security.next-btn'));
                $('.phone-tab .tab-icon')
                    .removeClass('state-warning')
                    .addClass('state-normal');
                $('.js-settings-phone .security-settings-field').removeClass('warning');
                $('.js-settings-phone .text-title').text(i18n('%profile.securiy.field-phone_binded'));
                $('.security-settings-finish-text').html(
                    yr.run('profile.security', {message: i18n('%profile.security.status-nowgood')}, 'securityData')
                );
                passport.api.log('security level ' + response.securityLevel);
            });
        },

        confirmNumber: function(id) {
            var self = this;

            passport.api
                .request('yasms.prolong', {id: id, track_id: $('#track_id').val()})
                .done(function(response) {
                    if (response && response.status === 'ok') {
                        passport.api.log('security page phone confirmed');
                        self.phoneConfirmed = true;
                    }
                    if (response.status === 'error') {
                        if (response.errors.indexOf('sessionid.invalid') !== -1) {
                            location.href = '//' + location.host + '/auth?retpath=' + encodeURIComponent(location.href);
                        }
                    }
                })
                .fail(function() {
                    passport.api.log('security page confirmNumber failed');
                });
        },

        init: function() {
            this.journalEvent = $('.security-settings-journal-event');
            this.cancelPhoneBinding = $('.js-cancel-phone');
        }
    });

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    $('input:visible')
        .first()
        .focus();

    $(document).on(metricEvent, '.js-metrics-return-button', function() {
        sendMetric(['Готово', 'Закрыть']);
        metricsReachGoal(['finish']);
    });

    $(document).on(metricEvent, '.js-metrics-profile-password', function() {
        sendMetric(['Пароль', 'Сменить пароль']);
    });

    $(document).on(metricEvent, '.js-metrics-password-link-later', function() {
        sendMetric(['Пароль', 'Сменю позже']);
    });

    $(document).on(metricEvent, '.js-metrics-password-link-next', function() {
        sendMetric(['Пароль', 'Продолжить']);
    });

    $(document).on(metricEvent, '.phone-confirm-entry__init-confirm', function() {
        sendMetric(['Номер телефона', 'Получить код']);
        metricsReachGoal(['phone', 'get_code']);
    });

    $(document).on(metricEvent, '.submit_code.js-confirm-code', function() {
        sendMetric(['Номер телефона', 'Подтвердить']);
        metricsReachGoal(['phone', 'confirm']);
    });

    $(document).on(metricEvent, '.js-metrics-phone-link-next', function() {
        sendMetric(['Номер телефона', 'Продолжить']);
        metricsReachGoal(['phone', 'next']);
    });

    $(document).on(metricEvent, '.js-metrics-phone-link-later', function() {
        sendMetric(['Номер телефона', 'Привяжу позже']);
        metricsReachGoal(['phone', 'later']);
    });

    $(document).on(metricEvent, '.js-metrics-phone-link-cancel', function() {
        sendMetric(['Номер телефона', 'Передумал']);
    });

    $(document).on(metricEvent, '.js-metrics-phone-link-change', function() {
        sendMetric(['Номер телефона', 'Нужно заменить']);
    });

    $(document).on(metricEvent, '.js-metrics-phone-link-mynumber', function() {
        sendMetric(['Номер телефона', 'Это мой номер']);
        metricsReachGoal(['phone', 'mynumber']);
    });

    $(document).on(metricEvent, '.js-metrics-email-link-connect', function() {
        sendMetric(['Запасная почта', 'Привязать адрес/Нет, нужно заменить/Изменить список адресов']);
    });

    $(document).on(metricEvent, '.js-metrics-email-link-next', function() {
        sendMetric(['Запасная почта', 'Продолжить/Это мой адрес']);
    });

    $(document).on(metricEvent, '.js-metrics-email-link-later', function() {
        sendMetric(['Запасная почта', 'Привяжу позже']);
    });

    $(document).on(metricEvent, '.js-metrics-history-link-finish', function() {
        sendMetric(['История входов', 'Все в порядке']);
    });

    $(window).on('load', function() {
        var $activeTab = $('.active-tab');

        $activeTab.each(function(indx, tab) {
            var kind = $(tab)
                .attr('class')
                .match(/(phone|account|email|history)-tab/);

            if (kind) {
                metricsReachGoal([kind[0], 'show_block']);
            }
        });
    });

    sendMetric(['Показ страницы']);
});
