// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/social/broker.js */

$(function() {
    passport.block('profile-social', {
        events: {
            'click .js-settings-hide': 'hideSettings',
            'click .js-settings-show': 'showSettings',
            'click .js-subscription-toggler': 'toggleServiceSubscribes',
            'click .js-allowAuth-toggler': 'toggleAuthPermission',
            'click .js-profile-remove': 'processProfileDelete',
            'click .js-show-popup': 'showDelPopup',
            'click .js-profile-remove-cansel': 'closeDelPopup',
            'click .js-istouch-toggler': 'toggleVisibility'
        },

        toggler: null,
        retpath: '',

        hideSettings: function() {
            var $block = $('.social-settings');

            $block.removeClass('active');
            document.cookie = 'profile_social.showSettings=; -1';
        },

        showSettings: function(event) {
            var id = $(event.currentTarget).data().provider;
            var elClass = '.settings-' + id;

            $(elClass).addClass('active');
            document.cookie = 'profile_social.showSettings= ' + id;
        },

        updateProfileList: function() {
            this.$('.removed').remove();
            if (!$('.profile-items').length) {
                $('.profile-social-list').hide();
                $('.js-profiles-subtitle').addClass('g-hidden');
                $('.js-no-profiles-subtitle').removeClass('g-hidden');
            }
        },

        processData: function(id, sId, obj) {
            this.errorBlock.addClass('g-hidden');
            var data = {
                track_id: this.track,
                csrf_token: $('#csrf_token').val(),
                profile_id: id
            };

            if (sId) {
                data.sid = sId;
            }

            if (obj) {
                data[obj.name] = obj.value;
            }
            return data;
        },

        toggleServiceSubscribes: function(event) {
            var that = this;
            var $toggler = $(event.currentTarget);
            var profile = $toggler.data().id;
            var sid = $toggler.data().sid;
            var apiMethod = 'enableSocialSubscribe';

            if ($toggler.hasClass('_nb-is-checked')) {
                apiMethod = 'disableSocialSubscribe';
            }
            $.when(this.processData(profile, sid)).then(function(res) {
                that.sendRequest(apiMethod, res);
            });
        },

        toggleAuthPermission: function(event) {
            event.stopPropagation();
            var that = this;
            var $toggler = $(event.currentTarget);
            var enableAuthPermition = Number(!$toggler.hasClass('_nb-is-checked'));
            var profile = $toggler.data().id;

            if (!enableAuthPermition) {
                $toggler.removeClass('_nb-is-checked');
            } else {
                $toggler.addClass('_nb-is-checked');
            }
            this.toggler = $toggler;
            $.when(this.processData(profile, null, {name: 'set_auth', value: enableAuthPermition})).then(function(res) {
                that.sendRequest('allowSocialAuth', res);
            });
        },

        processProfileDelete: function(event) {
            var that = this;
            var id = $(event.currentTarget).data().profile_id;
            var elClass = '.profile-' + id;

            $(elClass).addClass('removed');
            $.when(this.processData(id)).then(function(res) {
                that.sendRequest('delSocialProfile', res);
            });
        },

        showDelPopup: function(event) {
            var popupId = '#popup-del-' + $(event.currentTarget).data().id;
            var $popup = $(popupId);

            this.closeDelPopup();
            $popup.addClass('active');
        },

        closeDelPopup: function() {
            $('.b-popup').removeClass('active');
        },

        sendRequest: function(method, data) {
            var that = this;

            passport.api
                .request(method, data, {
                    cache: false,
                    abortPrevious: true
                })
                .done(function(response) {
                    if (response.error && Array.isArray(response.error)) {
                        if (response.error[0] === 'social_profile.single_auth_method' && method === 'allowSocialAuth') {
                            return that.processError(['social_profile.single_auth_toggle']);
                        }
                        if (response.error[0] === 'password.required') {
                            passport.block('password-domik').show(method, data);
                        } else {
                            that.processError(response.error);
                        }
                    }

                    if (response.status === 'ok') {
                        if (response.state === 'complete_social_with_login' || response.state === 'complete_social') {
                            location.href =
                                location.protocol +
                                '//' +
                                location.host +
                                '/passport?mode=postregistration&origin=passport_profile&retpath=' +
                                that.retpath;
                        }

                        if (response.user.cookies) {
                            location.href =
                                location.protocol +
                                '//' +
                                location.host +
                                '/auth/finish/?track_id=' +
                                response.user.track_id +
                                '&retpath=' +
                                that.retpath;
                        }

                        if (method === 'delSocialProfile') {
                            that.updateProfileList();
                        }
                    }
                });
        },

        processError: function(error) {
            var that = this;
            var message;
            var errorCode = error[0];
            var intErrors = ['track.not_found', 'track_id.empty', 'track.invalid_state', 'social_profile.invalid'];

            var isleErrors = {
                'account.strong_password_policy_enabled': i18n('%profile.social.auth-forbidden')
            };

            intErrors.forEach(function(item) {
                if (errorCode === item) {
                    location.href = that.retpath;
                }
            });

            for (var key in isleErrors) {
                if (key === errorCode) {
                    message = isleErrors[key];
                    this.errorBlock.find('.error-msg').text(message);
                    this.errorBlock.removeClass('g-hidden');
                    this.toggler.removeClass('_nb-is-checked');
                }
            }

            if (error && Array.isArray(error)) {
                if (errorCode === 'sessionid.invalid') {
                    location.href = location.protocol + '//' + location.host + '/auth?retpath=' + this.retpath;
                }
                if (errorCode === 'sslsession.required') {
                    location.href = location.protocol + '//' + location.host + '/auth/secure?retpath=' + this.retpath;
                }
                if (errorCode === 'social_profile.single_auth_method') {
                    location.href = location.protocol + '//' + location.host + '/passport?mode=delete';
                }
                if (errorCode === 'social_profile.single_auth_toggle') {
                    location.href =
                        location.protocol +
                        '//' +
                        location.host +
                        '/passport?mode=postregistration&origin=passport_profile&retpath=' +
                        this.retpath;
                }
            }
        },

        toggleVisibility: function(event) {
            var id = $(event.currentTarget).data().profile;
            var elClass = '.profile-' + id;

            $(elClass).toggleClass('show-settings');
        },

        init: function() {
            var that = this;

            this.retpath = location.protocol + '//' + location.host + $('body').data().retpath;
            this.track = $('#track_id').val();
            this.errorBlock = $('.error-isle');

            $(document).on('click', function(event) {
                var targets = $('.js-show-popup') || $('.popup-delete');

                if (!$(event.target).closest(targets).length) {
                    that.closeDelPopup();
                }
            });
        }
    });

    passport.block('password-domik', {
        events: {
            'click .js-password-button': 'processData',
            'click .js-domik-close': 'hide'
        },

        data: {},
        method: '',
        captchaRequired: false,

        show: function(method, data) {
            this.paranja.removeClass('g-hidden');
            this.passInput.focus();
            this.data = data;
            this.method = method;
            passport.block('profile-social').closeDelPopup();
            if (!this.captchaRequired) {
                $('.js-block_name_captcha').remove();
            }
        },

        hide: function(event) {
            var $toggler = passport.block('profile-social').toggler;

            if (event) {
                $('tr.profile-items').removeClass('removed');

                if ($toggler) {
                    if ($toggler.hasClass('_nb-is-checked')) {
                        $toggler.removeClass('_nb-is-checked');
                    } else {
                        $toggler.addClass('_nb-is-checked');
                    }
                    passport.block('profile-social').toggler = null;
                }
            }
            this.paranja.addClass('g-hidden');
            $('.js-block_name_captcha').remove();
            this.reset();
        },

        resetErrors: function() {
            this.captchaRequired = false;
            $('.domik-wrap .p-control__error').addClass('g-hidden');
        },

        reset: function() {
            var isCaptchaExist = $('.captcha__captcha__text').length;

            this.$(':input').val('');
            this.resetErrors();
            if (isCaptchaExist) {
                passport.block('captcha').getNewCode();
            }
        },

        sendRequest: function(method, data) {
            var that = this;

            passport.api
                .request(method, data, {
                    cache: false,
                    abortPrevious: true
                })
                .done(function(response) {
                    var retpath = location.protocol + '//' + location.host + $('body').data().retpath;

                    if (response.error) {
                        that.processError(response.error);
                    }
                    if (response.status === 'ok') {
                        if (response.user.cookies) {
                            location.href =
                                location.protocol +
                                '//' +
                                location.host +
                                '/auth/finish/?track_id=' +
                                response.user.track_id +
                                '&retpath=' +
                                retpath;
                        }
                        that.hide();
                        that.reset();
                        if (method === 'delSocialProfile') {
                            passport.block('profile-social').updateProfileList();
                        }
                    }
                });
        },

        processData: function(event) {
            event.preventDefault();
            var isCaptchaExist = $('.captcha__captcha__text').length;

            if (this.data !== null) {
                this.data.current_password = this.passInput.val();
            }
            if (this.captchaRequired || isCaptchaExist) {
                this.data.captcha_answer = $('#captcha_answer').val();
                this.captchaCheck(this.data.captcha_answer);
            } else {
                this.sendRequest(this.method, this.data);
            }
        },

        processError: function(error) {
            var errorList = {
                'current_password.empty': i18n('%password_current_errors_missingvalue'),
                'password.not_matched': i18n('%password_current_errors_not_matched'),
                'social_profile.auth_forbidden': i18n('%profile.social.auth-forbidden')
            };
            var message;

            if (Array.isArray(error)) {
                for (var key in errorList) {
                    if (error.indexOf(key) !== -1) {
                        message = errorList[key];
                        this.showError(message);
                    }
                }

                if (error.indexOf('captcha.required') !== -1) {
                    var isCaptchaExist = $('.captcha__captcha__text').length;

                    this.captchaRequired = true;

                    if (isCaptchaExist) {
                        var capthca = passport.block('captcha');

                        capthca.getNewCode();
                        capthca.val('');
                    } else {
                        this.captchaCompile();
                    }
                } else {
                    this.captchaRequired = false;
                    $('.js-block_name_captcha').remove();
                }
            }
        },

        showError: function(message) {
            var $errorBlock = $('.p-control_error_password-domik');

            $errorBlock.text(message).removeClass('g-hidden');
        },

        captchaCompile: function() {
            var that = this;

            passport.api
                .request('textcaptcha', {
                    cache: false,
                    abortPrevious: true
                })
                .done(function(response) {
                    var url = response.image_url;

                    that.captchaConstruct(url);
                });
        },

        captchaConstruct: function(url) {
            var lang = $('body').data().locale;
            var captchaParams = {
                control: {
                    id: 'captcha',
                    mode: 'text',
                    name: 'captcha_answer',
                    image_url: decodeURIComponent(url),
                    countryFromAudioWhiteList: true,
                    language: lang,
                    static: passport.staticPath,
                    label: i18n('%field_answer'),
                    error: [
                        {
                            code: 'missingvalue',
                            message: i18n('%answer_errors_missingvalue')
                        },
                        {
                            code: 'incorrect',
                            message: i18n('%answer_errors_incorrect')
                        }
                    ]
                }
            };

            this.$('.js-domik-captcha').html(yr.run('profile.social', captchaParams, 'captcha'));
            passport.block('captcha').construct($('*[data-block="p-control_captcha"]'));
            passport.validator.register(passport.ensureBlock('p-control_captcha'));
        },

        captchaCheck: function(answer) {
            var that = this;

            passport.api
                .request('captcha', {
                    answer: answer,
                    cache: false,
                    abortPrevious: true
                })
                .done(function(response) {
                    if (response.status === 'ok' && response.correct) {
                        that.resetErrors();
                        that.captchaRequired = false;
                        that.sendRequest(that.method, that.data);
                    } else {
                        passport.block('captcha').clearCaptcha();
                        passport.block('captcha').error('incorrect');
                    }
                })
                .fail(function() {
                    that.reset();
                    passport.block('captcha').error('missingvalue');
                });
        },

        init: function() {
            var that = this;

            this.paranja = $('.js-domik-paranja');
            this.form = $('.domik-form');
            this.passInput = $('.domik-password');

            this.$('input').keyup(function() {
                that.resetErrors();
            });

            this.paranja.click(function(event) {
                if (!$(event.target).closest('.js-block_name_password-domik').length) {
                    that.hide(event);
                }
            });
        }
    });

    passport.block('social-providers', {
        events: {
            'click .js-add-social': 'startSocialAuth'
        },

        _brokerParams: {},
        retpath: '',
        tld: null,

        brokerOnSuccess: function(message) {
            if (message.origin !== location.origin) {
                return;
            }

            if (message.data.socialAuth) {
                location.replace(this.retpath);
            }
        },

        brokerOnFailure: function() {},

        startSocialAuth: function(event) {
            var elem = $(event.currentTarget);
            var provider = elem.data('provider');

            if (provider) {
                this.broker.start({
                    provider: provider,
                    require_auth: 1
                });

                elem.blur();
            }
        },

        setupBroker: function() {
            var data = $('body').data();
            var brokerpath = data.brokerpath;

            this.tld = data.tld || 'ru';

            this._brokerParams.startUrl = brokerpath.replace('%tld%', this.tld);
            this._brokerParams.resize = 1;

            if (passport.isTouch) {
                this._brokerParams.display = 'touch';
                this._brokerParams.retnopopup = this.retpath;
            }

            this.broker = passport.block('broker');
            this.broker.init(this._brokerParams);
        },

        setup: function() {
            var that = this;
            var data = $('body').data();

            this.retpath = location.protocol + '//' + location.host + data.retpath;

            if (window.addEventListener) {
                window.addEventListener('message', that.brokerOnSuccess.bind(that), false);
            } else {
                window.attachEvent('onmessage', that.brokerOnSuccess.bind(that));
            }
        },

        init: function() {
            this.setupBroker();
            this.setup();
        }
    });

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
});
