import {createStore, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import rootReducer from '@blocks/AuthSilent/reducers';

const devTools =
    typeof window === 'object' &&
    typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.__REDUX_DEVTOOLS_EXTENSION__()
        : (f) => f;

export function configureStore(initialState) {
    return createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
