import {renderClient} from '@components/Layout/client';
import createBrowserHistory from 'history/createBrowserHistory';
import {loadableReady} from '@loadable/component';
import broker from '@blocks/authv2/broker';
import configureStore from '@blocks/authv2/configureStore';
import App from '@blocks/authv2/App.jsx';
import {cleanAmQueryParams} from '@blocks/authv2/nativeMobileApi';

loadableReady(() => {
    const reduxStore = window.__REDUX_STORE__;
    const {common = {}, social = {}} = reduxStore;
    const {pane, from} = common;
    const history = createBrowserHistory();

    if (from === 'social_auth') {
        const width = 500;

        let height = 600;

        if (window && window.screen && window.screen.width && window.screen.height) {
            if (window.screen.availHeight > 800) {
                height = 740;
            }

            window.moveTo((window.screen.width - width) / 2, (window.screen.height - height) / 2);
        }
        window.resizeTo(width, height);
    }

    renderClient({
        App,
        configureStore,
        withMagic: true,
        withRouter: true,
        history,
        replaceHistory: pane,
        replaceHistorySearch: cleanAmQueryParams(reduxStore),
        broker: social.brokerParams ? broker : undefined
    });
});
