import path from 'path';
import createMemoryHistory from 'history/createMemoryHistory';
import {renderServer} from '@components/Layout/server';
import configureStore from '@blocks/authv2/configureStore';
import App from '@blocks/authv2/App.jsx';
import {darkTheme} from 'pcomponents/Theme/darkTheme';

export const renderPage = (res) => {
    const {authPage, pdd_title: pddTitle, store = {}, page} = res.locals;
    const {common = {}, settings = {}} = store;
    const {pane} = common;
    const {language, theme} = settings;
    const isDarkTheme = theme === 'dark';
    const history = createMemoryHistory({initialEntries: [pane]});
    const loadableStatsFile = path.resolve(`./loadable/${language}/${page}/loadable-stats.json`);
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const themeInfo = {
        name: isDarkTheme ? 'dark' : 'default',
        cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
    };

    renderServer(res, {
        title: pddTitle ? pddTitle : i18n('_AUTH_.title.authorization'),
        extraProps: {isExtraMetaIconsAvailable: authPage === 'magiclink-auth', loadCustomsStyles: true, themeInfo},
        App,
        configureStore,
        history,
        withRouter: true,
        withLoadable: true,
        loadableStatsFile
    });
};
