import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import User from '@blocks/avatar-displayname/components/User/User.jsx';
import {PageWrapper} from '@components/PageWrapper';

class App extends Component {
    render() {
        const {
            settings: {isNewLayout, isPopupMode}
        } = this.props;

        return (
            <div className={classnames({'layout-inner': !isPopupMode})}>
                <PageWrapper unwrap={isPopupMode} isNavigationHidden={true}>
                    {!isPopupMode && !isNewLayout && <Header isAvatarPage={true} />}
                    <User />
                    {!isPopupMode && <Footer />}
                </PageWrapper>
            </div>
        );
    }
}

App.propTypes = {
    settings: PropTypes.shape({
        isPopupMode: PropTypes.bool,
        isNewLayout: PropTypes.bool
    })
};

export default connect((state) => state)(App);
