import {renderServer} from '@components/Layout/server';
import configureStore from './configureStore';
import {App} from './app.jsx';
import {darkTheme} from 'pcomponents/Theme/darkTheme';

export const renderPage = (res) => {
    const {store = {}} = res.locals;
    const {common = {}, settings = {}} = store;
    const {theme} = settings;
    const {loadCustomsStyles} = common;
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const isDarkTheme = theme === 'dark';
    const themeInfo = {
        name: isDarkTheme ? 'dark' : 'default',
        cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
    };

    return renderServer(res, {
        title: i18n('OneDomik.CheckData.pageTitle'),
        App,
        configureStore,
        extraProps: {loadCustomsStyles, themeInfo}
    });
};
