import {createStore, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import rootReducer from '../../../blocks/react-blocks/registration/reducers/main';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default (initialState) =>
    createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
