import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import thunkMiddleware from 'redux-thunk';
import deepSync from '@screens/DeepSync/reducers';

const stub = (state = {}) => state;
const rootReducer = combineReducers({
    deepSync,
    common: stub,
    metrics: stub,
    settings: stub
});

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default (initialState) =>
    createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
