import React from 'react';
import {cn} from '@bem-react/classname';
import {useSelector, shallowEqual} from 'react-redux';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {Domik} from '@blocks/morda/components/domik/domik.jsx';
import {PageWrapper} from '@components/PageWrapper';
import {DeleteData} from '@screens/DeleteData';

const b = cn('DataPage');

export const App = () => {
    const {tld, isNewLayout} = useSelector(
        ({settings: {tld, isNewLayout}}) => ({
            tld,
            isNewLayout
        }),
        shallowEqual
    );

    return (
        <PageWrapper>
            <div className={b({nl: isNewLayout})}>
                {!isNewLayout && <Header />}
                <DeleteData />
                <Footer helpUrl={`https://yandex.${tld}/support/passport/data.html`} isFeedbackLinkHidden={true} />
                <Domik />
            </div>
        </PageWrapper>
    );
};
