import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import thunkMiddleware from 'redux-thunk';
import common from '@blocks/common/reducers';
import deleteData from '@screens/DeleteData/reducers';
import header from '@blocks/morda/components/header/reducers';
import domik from '@blocks/morda/components/domik/reducers';
import {takeOutInfo} from '@blocks/takeout/reducers';

const stub = (state = {}) => state;
const rootReducer = combineReducers({
    deleteData,
    header,
    common,
    domik,
    takeOutInfo,
    tracks: stub,
    footer: stub,
    person: stub,
    access: stub,
    metrics: stub,
    settings: stub
});

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default (initialState) =>
    createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
