import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import reducers from '@blocks/passport.reducers';
import {createReduxMiddleware as createNativeMobileApiReduxMiddleware} from '@blocks/authv2/nativeMobileApi';

const devTools =
    typeof window === 'object' &&
    typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.__REDUX_DEVTOOLS_EXTENSION__()
        : (f) => f;

export default function(initialState) {
    const middlewares = [thunkMiddleware];

    if (typeof window === 'object' && initialState.am && initialState.am.isAm) {
        middlewares.push(createNativeMobileApiReduxMiddleware(initialState));
    }

    return createStore(combineReducers(reducers), initialState, compose(applyMiddleware(...middlewares), devTools));
}
