import path from 'path';
import {darkTheme} from 'pcomponents/Theme/darkTheme';
import {renderServer} from '@components/Layout/server';
import configureStore from './configureStore';
import {App} from './app';

const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';

export const renderPage = (res) => {
    const {store = {}, page} = res.locals;
    const {settings = {}} = store;
    const {theme, language} = settings;
    const isDarkTheme = theme === 'dark';

    renderServer(res, {
        title: i18n('Frontend.id.title'),
        App,
        configureStore,
        withLoadable: true,
        extraProps: {
            themeInfo: {
                name: isDarkTheme ? 'dark' : 'default',
                cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
            }
        },
        loadableStatsFile: path.resolve(`./loadable/${language}/${page}/loadable-stats.json`)
    });
};
