import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import reducers from '@blocks/passport.reducers';
import {connectRouter, routerMiddleware} from 'connected-react-router';

const getRootReducer = (history) =>
    combineReducers(
        Object.assign({}, reducers, {
            router: connectRouter(history)
        })
    );

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState, history) {
    const middlewares = [thunkMiddleware, routerMiddleware(history)];

    return createStore(getRootReducer(history), initialState, compose(applyMiddleware(...middlewares), devTools));
}
