import {renderClient} from '@components/Layout/client';
import configureStore from './configureStore';
import {FamilyWebview} from '@blocks/webview/FamilyWebview';
import createBrowserHistory from 'history/createBrowserHistory';

document.addEventListener('DOMContentLoaded', () => {
    const history = createBrowserHistory();

    history.listen(() => (window || {}).scrollTo && window.scrollTo(0, 0));

    renderClient({
        App: FamilyWebview,
        configureStore,
        withRouter: true,
        history
    });
});
