import {renderServer} from '@components/Layout/server';
import {FamilyWebview} from '@blocks/webview/FamilyWebview';
import configureStore from './configureStore';
import {darkTheme} from 'pcomponents/Theme/darkTheme';
import createMemoryHistory from 'history/createMemoryHistory';

export const renderPage = (res) => {
    const {store = {}} = res.locals;
    const {settings = {}} = store;
    const {theme, location} = settings;
    const isDarkTheme = theme === 'dark';
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const themeInfo = {
        name: isDarkTheme ? 'dark' : 'default',
        cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
    };
    const history = createMemoryHistory({initialEntries: [location]});

    renderServer(res, {
        title: i18n('Frontend.id.title'),
        App: FamilyWebview,
        withRouter: true,
        history,
        configureStore,
        extraProps: {themeInfo}
    });
};
