import React from 'react';
import {useSelector} from 'react-redux';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {PageWrapper} from '@components/PageWrapper';
import {LoginMethod} from '@blocks/LoginMethod';
import {PhoneBindConfirmModal} from '@blocks/Screens/PhoneBindConfirm/PhoneBindConfirmModal';

export const App = () => {
    const isNewLayout = useSelector((state) => state.settings.isNewLayout);

    return (
        <div className='layout-inner'>
            <PageWrapper>
                {!isNewLayout && <Header />}
                <LoginMethod />
                <Footer />
                <PhoneBindConfirmModal />
            </PageWrapper>
        </div>
    );
};
