import {createStore, applyMiddleware, combineReducers, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import common from '../../../blocks/react-blocks/common/reducers';
import tracks from '@blocks/reducers/tracks';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export const stub = (state = {}) => state;

const rootReducer = combineReducers({
    common,
    settings: stub,
    error: stub,
    metrics: stub,
    monitoring: stub,
    footer: stub,
    tracks
});

export default function(initialState) {
    return createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
