import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {withRouter} from 'react-router-dom';
import {Footer} from '@components/Footer/New.js';
import {PageWrapper} from '@components/PageWrapper';
import {Phones} from '@blocks/phones/entries/Phones';

class App extends Component {
    render() {
        const {settings, footer, location} = this.props;
        const {isWebview} = settings;

        return (
            <div className='layout-inner'>
                <PageWrapper unwrap={isWebview}>
                    <Phones location={location} />
                    {!isWebview && (
                        <Footer
                            settings={settings}
                            env={settings.env}
                            location={location.pathname}
                            help={settings.help}
                            langlist={footer.langlist}
                            tld={settings.tld}
                            language={settings.language}
                        />
                    )}
                </PageWrapper>
            </div>
        );
    }
}

App.propTypes = {
    settings: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired,
    location: PropTypes.shape({
        pathname: PropTypes.string.isRequired
    }).isRequired
};

export default withRouter(connect((state) => state)(App));
