import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import reducers from '@blocks/phones/reducers';
import {connectRouter, routerMiddleware} from 'connected-react-router';
import {devTools} from '../../devTools';

export default (initialState, history) =>
    createStore(
        combineReducers(Object.assign({}, reducers, {router: connectRouter(history)})),
        initialState,
        compose(applyMiddleware(thunkMiddleware, routerMiddleware(history)), devTools)
    );
