import {renderClient} from '@components/Layout/client';
import createBrowserHistory from 'history/createBrowserHistory';
import configureStore from './configureStore';
import App from './app.jsx';

document.addEventListener('DOMContentLoaded', () => {
    const history = createBrowserHistory();

    history.listen(() => (window || {}).scrollTo && window.scrollTo(0, 0));

    renderClient({
        App,
        configureStore,
        withRouter: true,
        history
    });
});
