import {renderServer} from '@components/Layout/server';
import createMemoryHistory from 'history/createMemoryHistory';
import App from './app.jsx';
import configureStore from './configureStore';

export const renderPage = (res) => {
    const {settings = {}} = res.locals.store || {};
    const {location} = settings;
    const history = createMemoryHistory({initialEntries: [location || '/profile/phones']});

    renderServer(res, {
        title: i18n('Phones.phones.title'),
        App,
        configureStore,
        history,
        withRouter: true
    });
};
