import React from 'react';
import {connect} from 'react-redux';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {PublicId} from '@screens/PublicId';
import {PageWrapper} from '@components/PageWrapper';
import PropTypes from 'prop-types';

const App = ({publicId: {isPopupMode = false} = {}, settings: {isNewLayout = false} = {}}) => (
    <div className='layout-inner'>
        <PageWrapper unwrap={isPopupMode}>
            {!isPopupMode && !isNewLayout && <Header />}
            <PublicId />
            {!isPopupMode && <Footer />}
        </PageWrapper>
    </div>
);

App.propTypes = {
    publicId: PropTypes.shape({
        isPopupMode: PropTypes.bool
    }),
    settings: PropTypes.shape({
        isNewLayout: PropTypes.bool
    })
};

const ConnectedApp = connect((state) => state)(App);

export {ConnectedApp as App};
